/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Identity;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.tracker.ServiceTrackerClient;
import org.pi4soa.service.tracker.ServiceTrackerExceptionHandler;
import org.pi4soa.service.tracker.ServiceTrackerListener;
import org.pi4soa.service.tracker.TrackerRecord;
import org.pi4soa.service.tracker.impl.TrackerRecordImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultServiceTrackerClient
implements ServiceTrackerClient {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker");
    private List<ServiceTrackerListener> m_listeners = new Vector<ServiceTrackerListener>();
    private ServiceTrackerExceptionHandler m_exceptionHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceTrackerListener(ServiceTrackerListener l) throws ServiceException {
        List<ServiceTrackerListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceTrackerListener(ServiceTrackerListener l) throws ServiceException {
        List<ServiceTrackerListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(l);
        }
    }

    public int getNumberOfServiceTrackerListeners() {
        return this.m_listeners.size();
    }

    public void setExceptionHandler(ServiceTrackerExceptionHandler handler) throws ServiceException {
        this.m_exceptionHandler = handler;
    }

    protected void reportException(Throwable ex) {
        if (this.m_exceptionHandler != null) {
            this.m_exceptionHandler.handleException(ex);
        }
    }

    public TrackerRecord[] queryRecords(String service, String participant, String version, Identity identity) throws ServiceException {
        return new TrackerRecord[0];
    }

    protected void handleTrackerRecord(String record) {
        try {
            Node elem = XMLUtils.getNode((String)record);
            if (elem instanceof Element) {
                TrackerRecordImpl rec = new TrackerRecordImpl((Element)elem);
                this.handleTrackerRecord(rec);
            }
        }
        catch (Exception e) {
            logger.severe("Failed to transform tracker record: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTrackerRecord(TrackerRecord record) {
        List<ServiceTrackerListener> list = this.m_listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.m_listeners.size()) {
                ServiceTrackerListener l = this.m_listeners.get(i);
                try {
                    l.handleTrackerRecord(record);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Service tracker listener '" + l + "' has thrown an exception: " + t, t);
                }
                ++i;
            }
        }
    }

    public void close() throws ServiceException {
    }
}

