/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker;

import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.tracker.PublishingServiceTracker;

public class FileBasedServiceTracker
extends PublishingServiceTracker {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker");
    private String m_location = null;
    private static Map<String, FileOutputStream> m_files = new Hashtable<String, FileOutputStream>();
    private static Map<String, Integer> m_fileRefCounts = new Hashtable<String, Integer>();

    public void setFile(String location) {
        this.m_location = location;
    }

    public String getFile() {
        return this.m_location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws ServiceException {
        if (this.m_location != null) {
            Map<String, FileOutputStream> map = m_files;
            synchronized (map) {
                if (!m_files.containsKey(this.m_location)) {
                    try {
                        logger.finest("Opening file for '" + this.m_location + "'");
                        FileOutputStream fos = new FileOutputStream(this.m_location);
                        m_files.put(this.m_location, fos);
                        m_fileRefCounts.put(this.m_location, new Integer(1));
                        fos.write("<records>\r\n".getBytes());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to open file for logging '" + this.m_location + "'", e);
                        throw new ServiceException("Failed to open file '" + this.m_location + "' for logging", e);
                    }
                } else {
                    Integer refCount = m_fileRefCounts.get(this.m_location);
                    logger.finest("Incrementing ref count for '" + this.m_location + "' to " + (refCount - 1));
                    m_fileRefCounts.put(this.m_location, new Integer(refCount + 1));
                }
            }
        } else {
            logger.severe("Failed to initialize file based logging - file location not specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(String serviceName, Session session, String mesg) {
        block6: {
            if (this.m_location != null) {
                try {
                    String xml = String.valueOf(mesg) + "\r\n";
                    Map<String, FileOutputStream> map = m_files;
                    synchronized (map) {
                        FileOutputStream fos = m_files.get(this.m_location);
                        fos.write(xml.getBytes());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to log service tracker record to file '" + this.m_location + "'", e);
                    if (!logger.isLoggable(Level.FINEST)) break block6;
                    logger.finest("Failed to log record: " + mesg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ServiceException {
        if (this.m_location != null) {
            Map<String, FileOutputStream> map = m_files;
            synchronized (map) {
                try {
                    Integer refCount = m_fileRefCounts.get(this.m_location);
                    if (refCount <= 1) {
                        logger.finest("Closing file for '" + this.m_location + "'");
                        FileOutputStream fos = m_files.get(this.m_location);
                        fos.write("</records>\r\n".getBytes());
                        fos.close();
                        m_files.remove(this.m_location);
                        m_fileRefCounts.remove(this.m_location);
                    } else {
                        logger.finest("Decrementing ref count for '" + this.m_location + "' to " + (refCount - 1));
                        m_fileRefCounts.put(this.m_location, new Integer(refCount - 1));
                    }
                }
                catch (Exception e) {
                    throw new ServiceException("Failed to close logging file", e);
                }
            }
        }
    }
}

