/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.service.Message;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.tracker.AbstractServiceTracker;

public abstract class PublishingServiceTracker
extends AbstractServiceTracker {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker");
    private Hashtable m_eventStore = new Hashtable();

    protected boolean isIdExpanded() {
        return false;
    }

    protected void record(String serviceName, String serviceVersion, Session session, Message mesg, String xml, String type, Throwable exc) {
        if (!this.canPublish(serviceName, session, type)) {
            this.store(serviceName, session, xml);
        } else {
            String[] pendingList = null;
            pendingList = this.getPendingList(serviceName, session);
            String message = this.build(serviceName, serviceVersion, session, mesg, xml, pendingList);
            this.publish(serviceName, session, message);
        }
    }

    protected void record(String serviceName, Session session, String xml, String type, Throwable exc) {
        this.record(serviceName, null, session, null, xml, type, exc);
    }

    protected boolean canPublish(String serviceName, Session session, String type) {
        boolean ret = false;
        if (session == null || session.getId() == null || session.getId().getServiceInstanceId() == null || session.getSessionIdentity() != null || session.getPrimaryIdentities().size() > 0) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(String serviceName, Session session, String xml) {
        if (session != null) {
            Hashtable hashtable = this.m_eventStore;
            synchronized (hashtable) {
                Vector<String> events = (Vector<String>)this.m_eventStore.get(session.getId().getServiceInstanceId());
                if (events == null) {
                    events = new Vector<String>();
                    this.m_eventStore.put(session.getId().getServiceInstanceId(), events);
                }
                events.add(xml);
            }
        } else {
            logger.severe("Cannot store stateless tracker event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPendingList(String serviceName, Session session) {
        Object[] ret = null;
        if (session != null && session.getId() != null && session.getId().getServiceInstanceId() != null) {
            Hashtable hashtable = this.m_eventStore;
            synchronized (hashtable) {
                Vector events = (Vector)this.m_eventStore.get(session.getId().getServiceInstanceId());
                if (events == null) {
                    ret = new String[]{};
                } else {
                    ret = new String[events.size()];
                    events.copyInto(ret);
                    this.m_eventStore.remove(session.getId().getServiceInstanceId());
                }
            }
        } else {
            ret = new String[]{};
        }
        return ret;
    }

    protected String build(String serviceName, String serviceVersion, Session session, Message mesg, String xml, String[] pendingList) {
        StringBuffer ret = new StringBuffer();
        String versionText = "";
        String nameText = "";
        if (serviceName != null) {
            nameText = "name=\"" + serviceName + "\" ";
        }
        if (serviceVersion != null) {
            versionText = "version=\"" + serviceVersion + "\" ";
        } else if (session != null && session.getId() != null && session.getId().getServiceDescriptionVersion() != null) {
            versionText = "version=\"" + session.getId().getServiceDescriptionVersion() + "\" ";
        }
        ret.append("<sd:record xmlns:sd=\"http://www.servicedescription.org/service/tracker\" " + nameText + versionText + ">");
        ret.append(this.getSessionIdentityText(session, mesg));
        ret.append("<sd:events>");
        if (pendingList != null && pendingList.length > 0) {
            int i = 0;
            while (i < pendingList.length) {
                ret.append(pendingList[i]);
                ++i;
            }
        }
        ret.append(xml);
        ret.append("</sd:events>");
        ret.append("</sd:record>");
        return ret.toString();
    }

    protected abstract void publish(String var1, Session var2, String var3);
}

