/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker.impl;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Channel;
import org.pi4soa.service.DefaultChannel;
import org.pi4soa.service.DefaultEndpointReference;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.session.impl.MessageImpl;
import org.pi4soa.service.tracker.TrackerEvent;
import org.pi4soa.service.tracker.impl.TrackerInformationUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerEventImpl
implements TrackerEvent {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker.impl");
    private Element m_eventElement = null;
    private boolean m_messageInitialized = false;
    private Message m_message = null;
    private boolean m_channelInitialized = false;
    private Channel m_channel = null;
    private long m_timestamp = -1L;
    private String m_exception = null;

    public TrackerEventImpl(Element event) {
        this.m_eventElement = event;
        this.m_eventElement.normalize();
        this.initialize();
    }

    protected void initialize() {
        Node exception = XMLUtils.getChild((Element)this.m_eventElement, null, (String)"exception");
        if (exception != null && exception.getFirstChild() instanceof Text) {
            this.m_exception = ((Text)exception.getFirstChild()).getNodeValue();
        }
    }

    @Override
    public String getEventType() {
        return this.m_eventElement.getLocalName();
    }

    @Override
    public String getName() {
        return this.m_eventElement.getAttribute("name");
    }

    @Override
    public String getServiceInstanceId() {
        return this.m_eventElement.getAttribute("serviceInstanceId");
    }

    @Override
    public String getSessionId() {
        return this.m_eventElement.getAttribute("sessionId");
    }

    @Override
    public String getLocalSessionId() {
        return this.m_eventElement.getAttribute("sessionId");
    }

    @Override
    public String getLocalParentSessionId() {
        return this.m_eventElement.getAttribute("parentSessionId");
    }

    @Override
    public String getParentSessionId() {
        return this.m_eventElement.getAttribute("parentSessionId");
    }

    @Override
    public long getTimestamp() {
        if (this.m_timestamp == -1L) {
            this.m_timestamp = 0L;
            if (this.m_eventElement.hasAttribute("timestamp")) {
                String val = this.m_eventElement.getAttribute("timestamp");
                try {
                    this.m_timestamp = Long.parseLong(val);
                }
                catch (Exception e) {
                    logger.severe("Unable to parse 'timestamp' service tracker event field value '" + val + "': " + e);
                }
            }
        }
        return this.m_timestamp;
    }

    @Override
    public Message getMessage() {
        if (!this.m_messageInitialized) {
            this.m_message = this.initializeMessage();
            this.m_messageInitialized = true;
        }
        return this.m_message;
    }

    protected Message initializeMessage() {
        Node message;
        MessageImpl ret = null;
        if (this.m_eventElement != null && (message = XMLUtils.getChild((Element)this.m_eventElement, null, (String)"message")) instanceof Element) {
            String faultName = null;
            String messageType = null;
            Element mesg = (Element)message;
            boolean isRequest = false;
            boolean isMessage = false;
            EndpointReference endpoint = null;
            Identity sessionIdentity = null;
            Identity channelIdentity = null;
            if (mesg.hasAttribute("fault")) {
                faultName = mesg.getAttribute("fault");
            }
            if (mesg.hasAttribute("messageType")) {
                messageType = mesg.getAttribute("messageType");
            }
            if (mesg.hasAttribute("type")) {
                if (mesg.getAttribute("type").equals("request")) {
                    isRequest = true;
                } else if (mesg.getAttribute("type").equals("message")) {
                    isMessage = true;
                }
            }
            endpoint = this.initializeEndpoint(mesg);
            sessionIdentity = this.initializeIdentity(mesg, "sessionIdentity");
            channelIdentity = this.initializeIdentity(mesg, "channelIdentity");
            String serviceType = mesg.getAttribute("serviceType");
            if (serviceType != null && serviceType.trim().length() == 0) {
                serviceType = null;
            }
            String value = this.initializeValue(mesg);
            ret = new MessageImpl(mesg.getAttribute("operation"), faultName, messageType, isRequest, serviceType, endpoint, (Serializable)((Object)value), sessionIdentity, channelIdentity);
            ret.setRPCStyle(!isMessage);
            ret.setMessageIdentities(this.initializeIdentities(mesg, "primaryIdentities"));
            if (this.m_eventElement.getLocalName().equals("sentMessage")) {
                ret.setOutbound(true);
            }
        }
        return ret;
    }

    protected EndpointReference initializeEndpoint(Element mesg) {
        DefaultEndpointReference ret = null;
        Node endpointNode = XMLUtils.getChild((Element)mesg, null, (String)"endpoint");
        if (endpointNode != null && endpointNode.getFirstChild() != null) {
            try {
                String text = XMLUtils.getText((Node)endpointNode.getFirstChild());
                ret = new DefaultEndpointReference(text);
            }
            catch (Exception e) {
                logger.severe("Failed to extract endpoint reference: " + e);
            }
        }
        return ret;
    }

    protected Identity initializeIdentity(Element elem, String identityNode) {
        List<Identity> ids;
        Node sessionIdentity;
        Identity ret = null;
        if (elem != null && (sessionIdentity = XMLUtils.getChild((Element)elem, null, (String)identityNode)) != null && (ids = TrackerInformationUtil.getIdentities(sessionIdentity)) != null && ids.size() == 1) {
            ret = ids.get(0);
        }
        return ret;
    }

    protected List<Identity> initializeIdentities(Element elem, String identityNode) {
        Node sessionIdentity;
        List<Identity> ret = null;
        if (elem != null && (sessionIdentity = XMLUtils.getChild((Element)elem, null, (String)identityNode)) != null && (ret = TrackerInformationUtil.getIdentities(sessionIdentity)) != null && ret.size() == 0) {
            ret = null;
        }
        return ret;
    }

    protected Identity initializeChannelIdentity(Element messageElement) {
        List<Identity> ids;
        Node sessionIdentity;
        Identity ret = null;
        if (messageElement != null && (sessionIdentity = XMLUtils.getChild((Element)messageElement, null, (String)"sessionIdentity")) != null && (ids = TrackerInformationUtil.getIdentities(sessionIdentity)) != null && ids.size() == 1) {
            ret = ids.get(0);
        }
        return ret;
    }

    protected String initializeValue(Element messageElement) {
        String ret = null;
        if (messageElement != null) {
            Node valueNode = XMLUtils.getChild((Element)messageElement, null, (String)"value");
            if (valueNode != null) {
                valueNode = valueNode.getFirstChild();
            }
            while (valueNode != null && !(valueNode instanceof Element)) {
                valueNode = valueNode.getNextSibling();
            }
            if (valueNode != null) {
                try {
                    ret = XMLUtils.getText((Node)valueNode);
                }
                catch (Exception e) {
                    logger.severe("Failed to initialize message value: " + e);
                }
            }
        }
        return ret;
    }

    @Override
    public Channel getChannel() {
        if (!this.m_channelInitialized) {
            this.m_channel = this.initializeChannel();
            this.m_channelInitialized = true;
        }
        return this.m_channel;
    }

    protected Channel initializeChannel() {
        Node channel;
        DefaultChannel ret = null;
        if (this.m_eventElement != null && (channel = XMLUtils.getChild((Element)this.m_eventElement, null, (String)"channel")) instanceof Element) {
            String name = ((Element)channel).getAttribute("name");
            String type = ((Element)channel).getAttribute("type");
            List<Identity> ids = this.initializeIdentities((Element)channel, "primaryIdentities");
            ret = new DefaultChannel(name, type, null, null);
            int i = 0;
            while (ids != null && i < ids.size()) {
                ret.addPrimaryIdentity(ids.get(i));
                ++i;
            }
        }
        return ret;
    }

    @Override
    public String getDetails() {
        String ret = null;
        if (this.m_eventElement.hasAttribute("version")) {
            ret = this.m_eventElement.getAttribute("version");
        } else {
            NodeList nl = this.m_eventElement.getElementsByTagNameNS("*", "details");
            if (nl.getLength() > 0) {
                Node node = nl.item(0);
                if (node.getChildNodes().getLength() == 1 && node.getFirstChild() instanceof Text) {
                    ret = node.getFirstChild().getNodeValue();
                    ret = ret.trim();
                } else {
                    NodeList elemnl = node.getChildNodes();
                    Element elem = null;
                    int i = 0;
                    while (elem == null && i < elemnl.getLength()) {
                        if (elemnl.item(i) instanceof Element) {
                            elem = (Element)elemnl.item(i);
                        }
                        ++i;
                    }
                    if (elem != null) {
                        try {
                            ret = XMLUtils.getText(elem);
                        }
                        catch (Exception e) {
                            logger.severe("Failed to convert XML details to text: " + e);
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public String getException() {
        return this.m_exception;
    }

    @Override
    public String toXML() {
        String ret = null;
        try {
            ret = XMLUtils.getText((Node)this.m_eventElement, (boolean)true);
        }
        catch (Exception e) {
            logger.severe("Failed to convert tracker event to XML: " + e);
        }
        return ret;
    }
}

