/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker.impl;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Identity;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerInformationUtil {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker.impl");
    private static final String[] EVENT_NAMES = new String[]{"serviceStarted", "serviceFinished", "subSessionStarted", "subSessionFinished", "sentMessage", "receivedMessage", "unexpectedMessage", "unhandledException", "information", "warning", "error"};

    public static boolean isTrackerEvent(Element event) {
        boolean ret = false;
        int i = 0;
        while (event != null && !ret && i < EVENT_NAMES.length) {
            if (event.getLocalName().equals(EVENT_NAMES[i])) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public static List<Identity> getIdentities(Node node) {
        Vector<Identity> ret = new Vector<Identity>();
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            String id = null;
            String name = null;
            Node n = nl.item(i);
            if (n instanceof Element && n.getLocalName().equals("identity")) {
                name = ((Element)n).getAttribute("name");
                Node identity = n.getFirstChild();
                if (identity instanceof Text) {
                    id = ((Text)identity).getNodeValue();
                    id = XMLUtils.decodeXMLString((String)id);
                } else {
                    try {
                        id = XMLUtils.getText((Node)identity);
                        int index = id.indexOf("<?xml");
                        if (index != -1) {
                            index = id.indexOf("<", index + 1);
                            id = id.substring(index);
                        }
                    }
                    catch (Exception e) {
                        logger.severe("Failed to extract identity: " + e);
                    }
                }
            }
            if (id != null) {
                ret.add(new Identity(name, id));
            }
            ++i;
        }
        return ret;
    }
}

