/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker.impl;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Identity;
import org.pi4soa.service.tracker.TrackerEvent;
import org.pi4soa.service.tracker.TrackerRecord;
import org.pi4soa.service.tracker.impl.TrackerEventImpl;
import org.pi4soa.service.tracker.impl.TrackerInformationUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerRecordImpl
implements TrackerRecord {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker.impl");
    private static final String RECORD = "record";
    private static final String EVENTS = "events";
    private Element m_recordElement = null;
    private TrackerEvent[] m_trackerEvents = null;
    private List<Identity> m_primaryIdentities = null;
    private Identity m_sessionIdentity = null;
    private boolean m_sessionIdentityInitialized = false;
    private static final List<Identity> EMPTY_IDENTITY_LIST = new Vector<Identity>();

    public TrackerRecordImpl(Element elem) {
        this.m_recordElement = elem;
    }

    @Override
    public String getServiceDescriptionName() {
        return this.m_recordElement.getAttribute("name");
    }

    @Override
    public String getServiceDescriptionVersion() {
        return this.m_recordElement.getAttribute("version");
    }

    @Override
    public Identity getSessionIdentity() {
        if (!this.m_sessionIdentityInitialized) {
            this.m_sessionIdentity = this.initializeSessionIdentity();
            this.m_sessionIdentityInitialized = true;
        }
        return this.m_sessionIdentity;
    }

    protected Identity initializeSessionIdentity() {
        List<Identity> ids;
        Node sessionIdentity;
        Identity ret = null;
        if (this.m_recordElement != null && this.m_recordElement.getLocalName().equals(RECORD) && (sessionIdentity = XMLUtils.getChild((Element)this.m_recordElement, null, (String)"sessionIdentity")) != null && (ids = TrackerInformationUtil.getIdentities(sessionIdentity)) != null && ids.size() == 1) {
            ret = ids.get(0);
        }
        return ret;
    }

    @Override
    public List<Identity> getPrimaryIdentities() {
        if (this.m_primaryIdentities == null) {
            this.m_primaryIdentities = this.initializePrimaryIdentities();
        }
        return this.m_primaryIdentities;
    }

    protected List<Identity> initializePrimaryIdentities() {
        Node primaryIdentities;
        List<Identity> ret = null;
        if (this.m_recordElement != null && this.m_recordElement.getLocalName().equals(RECORD) && (primaryIdentities = XMLUtils.getChild((Element)this.m_recordElement, null, (String)"primaryIdentities")) != null) {
            ret = TrackerInformationUtil.getIdentities(primaryIdentities);
        }
        if (ret == null) {
            ret = EMPTY_IDENTITY_LIST;
        }
        return ret;
    }

    @Override
    public TrackerEvent[] getTrackerEvents() {
        if (this.m_trackerEvents == null) {
            this.m_trackerEvents = this.initializeTrackerEvents();
        }
        return this.m_trackerEvents;
    }

    protected TrackerEvent[] initializeTrackerEvents() {
        Node events;
        Object[] ret = null;
        if (this.m_recordElement != null && this.m_recordElement.getLocalName().equals(RECORD) && (events = XMLUtils.getChild((Element)this.m_recordElement, null, (String)EVENTS)) != null) {
            Vector<TrackerEventImpl> evts = new Vector<TrackerEventImpl>();
            NodeList nl = events.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node cur = nl.item(i);
                if (cur instanceof Element && TrackerInformationUtil.isTrackerEvent((Element)cur)) {
                    evts.add(new TrackerEventImpl((Element)cur));
                }
                ++i;
            }
            ret = new TrackerEvent[evts.size()];
            evts.copyInto(ret);
        }
        if (ret == null) {
            ret = new TrackerEvent[]{};
        }
        return ret;
    }

    @Override
    public String toXML() {
        String ret = null;
        try {
            ret = XMLUtils.getText((Node)this.m_recordElement, (boolean)true);
        }
        catch (Exception e) {
            logger.severe("Failed to convert tracker record to XML: " + e);
        }
        return ret;
    }
}

