/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker.jms;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueConnectionFactory;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.tracker.PublishingServiceTracker;

public class JMSServiceTracker
extends PublishingServiceTracker {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker");
    protected static final String TRACKER_JNDI_INITIAL_CONTEXT_FACTORY_PROPERTY = "pi4soa.tracker.jndi.initialContextFactory";
    protected static final String TRACKER_JNDI_PROVIDER_URL_PROPERTY = "pi4soa.tracker.jndi.providerURL";
    protected static final String TRACKER_JNDI_FACTORY_URL_PACKAGES_PROPERTY = "pi4soa.tracker.jndi.factoryURLPackages";
    protected static final String TRACKER_JMS_TOPIC_CONNECTION_FACTORY_PROPERTY = "pi4soa.tracker.jms.topicConnectionFactory";
    protected static final String TRACKER_JMS_TOPIC_PROPERTY = "pi4soa.tracker.jms.topic";
    protected static final String TRACKER_JMS_CONNECTION_FACTORY_PROPERTY = "pi4soa.tracker.jms.connectionFactory";
    protected static final String TRACKER_JMS_CONNECTION_FACTORY_ALTERNATE_PROPERTY = "pi4soa.tracker.jms.connectionFactoryAlternate";
    protected static final String TRACKER_JMS_DESTINATION_PROPERTY = "pi4soa.tracker.jms.destination";
    protected static final String TRACKER_JMS_CLIENT_ID_PROPERTY = "pi4soa.tracker.jms.clientId";
    protected static final String TRACKER_JMS_DURABLE_SUBSCRIPTION_PROPERTY = "pi4soa.tracker.jms.durableSubscription";
    private boolean m_initialized = false;
    private String m_jndiInitialContextFactory = null;
    private String m_jndiProviderURL = null;
    private String m_jndiFactoryURLPackages = null;
    private String m_jmsConnectionFactory = null;
    private String m_jmsConnectionFactoryAlternate = null;
    private String m_jmsDestination = null;
    private Connection m_connection = null;
    private javax.jms.Session m_session = null;
    private MessageProducer m_producer = null;

    public void initialize() {
        InitialContext ctx = null;
        try {
            if (NamesUtil.isSet((String)this.m_jndiInitialContextFactory)) {
                Properties jndiProps = new Properties();
                jndiProps.setProperty("java.naming.factory.initial", this.m_jndiInitialContextFactory);
                jndiProps.setProperty("java.naming.provider.url", this.m_jndiProviderURL);
                if (this.m_jndiFactoryURLPackages != null) {
                    jndiProps.setProperty("java.naming.factory.url.pkgs", this.m_jndiFactoryURLPackages);
                }
                ctx = new InitialContext(jndiProps);
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Creating default initial context");
                }
                ctx = new InitialContext();
            }
        }
        catch (Exception e) {
            logger.severe("Failed to create JNDI initial context: " + e);
        }
        if (ctx != null) {
            try {
                try {
                    ConnectionFactory factory = (ConnectionFactory)ctx.lookup(this.m_jmsConnectionFactory);
                    this.m_connection = factory.createConnection();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Connection: " + this.m_connection);
                    }
                }
                catch (RuntimeException re) {
                    if (this.m_jmsConnectionFactoryAlternate != null) {
                        QueueConnectionFactory qcf = (QueueConnectionFactory)ctx.lookup(this.m_jmsConnectionFactoryAlternate);
                        this.m_connection = qcf.createQueueConnection();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Alternate Connection: " + this.m_connection);
                        }
                    }
                    throw re;
                }
                Destination dest = (Destination)ctx.lookup(this.m_jmsDestination);
                this.m_session = this.m_connection.createSession(false, 1);
                this.m_producer = this.m_session.createProducer(dest);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Thread.currentThread() + ": Created JMS ServiceTracker connection");
                }
            }
            catch (Exception e) {
                logger.severe("Failed to create JMS connection: " + e);
            }
        }
    }

    public void setJNDIInitialContextFactory(String factory) {
        this.m_jndiInitialContextFactory = factory;
    }

    public void setJNDIProviderURL(String url) {
        this.m_jndiProviderURL = url;
    }

    public void setJNDIFactoryURLPackages(String pkgs) {
        this.m_jndiFactoryURLPackages = pkgs;
    }

    public void setJMSConnectionFactory(String cf) {
        this.m_jmsConnectionFactory = cf;
    }

    public void setJMSConnectionFactoryAlternate(String cf) {
        this.m_jmsConnectionFactoryAlternate = cf;
    }

    public void setJMSDestination(String dest) {
        this.m_jmsDestination = dest;
    }

    protected synchronized void publish(String serviceName, Session session, String mesg) {
        if (!this.m_initialized && this.m_jmsConnectionFactory != null && this.m_jmsDestination != null) {
            this.initialize();
            this.m_initialized = true;
        }
        if (this.m_producer != null) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(mesg);
                }
                TextMessage tm = this.m_session.createTextMessage(mesg);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Sending JMS ServiceTracker record=" + tm);
                }
                this.m_producer.send((Message)tm);
            }
            catch (Exception e) {
                logger.severe("Failed to publish message: " + e);
            }
        } else {
            logger.warning("Could not publish message: " + mesg);
        }
    }

    public void close() throws ServiceException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Thread.currentThread() + ": Closing JMS ServiceTracker connection");
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (Exception e) {
            logger.severe("Failed to close JMS connection: " + e);
            this.m_initialized = false;
            throw new ServiceException("Failed to close JMS connection", e);
        }
        this.m_initialized = false;
    }
}

