/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker.jms;

import java.util.Properties;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.spi.InitialContextFactory;
import org.pi4soa.common.util.PropertyUtil;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.tracker.DefaultServiceTrackerClient;
import org.pi4soa.service.tracker.ServiceTrackerExceptionHandler;
import org.pi4soa.service.tracker.ServiceTrackerListener;
import org.pi4soa.service.tracker.TrackerRecord;

public class JMSServiceTrackerClient
extends DefaultServiceTrackerClient {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker");
    private boolean m_initialized = false;
    private String m_jndiInitialContextFactory = null;
    private String m_jndiProviderURL = null;
    private String m_jndiFactoryURLPackages = null;
    private String m_jmsConnectionFactory = null;
    private String m_jmsDestination = null;
    private String m_jmsClientId = null;
    private String m_jmsDurableSubscription = null;
    private InitialContextFactory m_factory = null;
    private TopicConnection m_connection = null;
    private TopicSession m_session = null;
    private TopicSubscriber m_subscriber = null;

    public static void main(String[] arg) {
        JMSServiceTrackerClient client = new JMSServiceTrackerClient();
        try {
            client.addServiceTrackerListener(new ServiceTrackerListener(){

                public void handleTrackerRecord(TrackerRecord record) {
                    System.out.println("RECORD------------------------");
                    System.out.println(record.toXML());
                }
            });
            client.setExceptionHandler(new ServiceTrackerExceptionHandler(){

                public void handleException(Throwable ex) {
                    System.out.println("EXCEPTION------------------------");
                    System.out.println(ex.getLocalizedMessage());
                }
            });
            try {
                Thread.sleep(1000000L);
            }
            catch (Exception e2) {
                System.err.println("Failed to wait for tracker client: " + e2);
                e2.printStackTrace();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to subscribe for tracker events: " + e);
            e.printStackTrace();
        }
    }

    protected void initialize() {
        if (this.m_jndiInitialContextFactory == null && PropertyUtil.hasProperty((String)"pi4soa.tracker.jndi.initialContextFactory")) {
            this.m_jndiInitialContextFactory = PropertyUtil.getProperty((String)"pi4soa.tracker.jndi.initialContextFactory");
        }
        if (this.m_jndiProviderURL == null && PropertyUtil.hasProperty((String)"pi4soa.tracker.jndi.providerURL")) {
            this.m_jndiProviderURL = PropertyUtil.getProperty((String)"pi4soa.tracker.jndi.providerURL");
            if (PropertyUtil.hasProperty((String)"pi4soa.tracker.jndi.factoryURLPackages")) {
                this.m_jndiFactoryURLPackages = PropertyUtil.getProperty((String)"pi4soa.tracker.jndi.factoryURLPackages");
            }
        }
        if (this.m_jmsConnectionFactory == null) {
            if (PropertyUtil.hasProperty((String)"pi4soa.tracker.jms.connectionFactory")) {
                this.m_jmsConnectionFactory = PropertyUtil.getProperty((String)"pi4soa.tracker.jms.connectionFactory");
            } else if (PropertyUtil.hasProperty((String)"pi4soa.tracker.jms.topicConnectionFactory")) {
                this.m_jmsConnectionFactory = PropertyUtil.getProperty((String)"pi4soa.tracker.jms.topicConnectionFactory");
            } else {
                logger.severe("Unable to identity 'JMS connection factory' for JMS service tracker");
            }
        }
        if (this.m_jmsDestination == null) {
            if (PropertyUtil.hasProperty((String)"pi4soa.tracker.jms.destination")) {
                this.m_jmsDestination = PropertyUtil.getProperty((String)"pi4soa.tracker.jms.destination");
            } else if (PropertyUtil.hasProperty((String)"pi4soa.tracker.jms.topic")) {
                this.m_jmsDestination = PropertyUtil.getProperty((String)"pi4soa.tracker.jms.topic");
            } else {
                logger.severe("Unable to identity 'JMS destination' for JMS service tracker");
            }
        }
        if (this.m_jmsClientId == null && PropertyUtil.hasProperty((String)"pi4soa.tracker.jms.clientId")) {
            this.m_jmsClientId = PropertyUtil.getProperty((String)"pi4soa.tracker.jms.clientId");
        }
        if (this.m_jmsDurableSubscription == null && PropertyUtil.hasProperty((String)"pi4soa.tracker.jms.durableSubscription")) {
            this.m_jmsDurableSubscription = PropertyUtil.getProperty((String)"pi4soa.tracker.jms.durableSubscription");
        }
        if (this.m_jmsDurableSubscription != null && this.m_jmsClientId == null) {
            logger.severe("Client id must be defined for durable subscription");
        }
    }

    protected void initializeJMS() throws ServiceException {
        this.initialize();
        if (this.m_jmsConnectionFactory == null || this.m_jmsDestination == null) {
            logger.severe("Unable to initialize JMS");
            throw new ServiceException("Unable to initialize JMS");
        }
        Properties jndiProps = null;
        if (this.m_jndiInitialContextFactory != null && this.m_jndiProviderURL != null) {
            jndiProps = new Properties();
            jndiProps.setProperty("java.naming.factory.initial", this.m_jndiInitialContextFactory);
            jndiProps.setProperty("java.naming.provider.url", this.m_jndiProviderURL);
            if (this.m_jndiFactoryURLPackages != null) {
                jndiProps.setProperty("java.naming.factory.url.pkgs", this.m_jndiFactoryURLPackages);
            }
        }
        Context ctx = null;
        try {
            ctx = this.m_factory != null ? this.m_factory.getInitialContext(jndiProps) : new InitialContext(jndiProps);
        }
        catch (Exception e) {
            logger.severe("Failed to create JNDI initial context: " + e);
            throw new ServiceException("Unable to obtain JNDI initial context", e);
        }
        if (ctx != null) {
            try {
                TopicConnectionFactory factory = (TopicConnectionFactory)ctx.lookup(this.m_jmsConnectionFactory);
                this.m_connection = factory.createTopicConnection();
                if (this.m_jmsClientId != null) {
                    this.m_connection.setClientID(this.m_jmsClientId);
                }
                Topic topic = (Topic)ctx.lookup(this.m_jmsDestination);
                this.m_session = this.m_connection.createTopicSession(false, 1);
                this.m_subscriber = this.m_jmsClientId != null && this.m_jmsDurableSubscription != null ? this.m_session.createDurableSubscriber(topic, this.m_jmsDurableSubscription) : this.m_session.createSubscriber(topic);
                this.m_subscriber.setMessageListener(new MessageListener(){

                    public void onMessage(Message m) {
                        if (m instanceof TextMessage) {
                            try {
                                JMSServiceTrackerClient.this.handleTrackerRecord(((TextMessage)m).getText());
                            }
                            catch (Exception e) {
                                logger.severe("Failed to receive tracker record: " + e);
                            }
                        }
                    }
                });
                this.m_connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException jmsex) {
                        JMSServiceTrackerClient.this.reportException((Throwable)jmsex);
                    }
                });
                this.m_connection.start();
                logger.fine("JMS Connection Started");
            }
            catch (Exception e) {
                logger.severe("Failed to create JMS connection: " + e);
                throw new ServiceException("Unable to establish JMS connection", e);
            }
        }
    }

    public void addServiceTrackerListener(ServiceTrackerListener l) throws ServiceException {
        super.addServiceTrackerListener(l);
        this.updateConnection();
    }

    public void removeServiceTrackerListener(ServiceTrackerListener l) throws ServiceException {
        super.removeServiceTrackerListener(l);
        this.updateConnection();
    }

    protected void updateConnection() throws ServiceException {
        if (!this.m_initialized && this.getNumberOfServiceTrackerListeners() > 0) {
            this.initializeJMS();
            this.m_initialized = true;
        }
    }

    public void setJNDIInitialContextFactory(String val) {
        this.m_jndiInitialContextFactory = val;
    }

    public void setJNDIProviderURL(String val) {
        this.m_jndiProviderURL = val;
    }

    public void setJNDIFactoryURLPackages(String val) {
        this.m_jndiFactoryURLPackages = val;
    }

    public void setJMSConnectionFactory(String val) {
        this.m_jmsConnectionFactory = val;
    }

    public void setJMSDestination(String val) {
        this.m_jmsDestination = val;
    }

    public void setJMSClientId(String id) {
        this.m_jmsClientId = id;
    }

    public void setJMSDurableSubscription(String name) {
        this.m_jmsDurableSubscription = name;
    }

    public void close() throws ServiceException {
        super.close();
        try {
            this.m_session.close();
            this.m_connection.close();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to close", e);
        }
        this.m_initialized = false;
    }

    public void setInitialContextFactory(InitialContextFactory factory) {
        this.m_factory = factory;
    }
}

