/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.util;

import java.io.InputStream;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathEvaluatorFactory;
import org.pi4soa.service.util.OperationMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultOperationMapper
implements OperationMapper {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.util");
    public static final String PI4SOA_OPERATION_MAP = "pi4soa_operation_map.xml";
    public static final String OPERATION_MAP_ELEMENT = "operationMap";
    public static final String SERVICE_TYPE_ELEMENT = "serviceType";
    public static final String OPERATION_ELEMENT = "operation";
    public static final String FAULT_ELEMENT = "fault";
    public static final String MESSAGE_TYPE_ATTR = "messageType";
    public static final String NAME_ATTR = "name";
    public static final String GUARD_ATTR = "guard";
    public static final String EXPRESSION_ATTR = "expression";
    private Element m_operationMappingInfo = null;
    private XPathEvaluator m_xpathEvaluator = XPathEvaluatorFactory.getXPathEvaluator();

    public DefaultOperationMapper() {
        try {
            InputStream is = DefaultOperationMapper.class.getClassLoader().getResourceAsStream(PI4SOA_OPERATION_MAP);
            Document doc = XMLUtils.loadDocument((InputStream)is);
            if (doc.getDocumentElement() != null && doc.getDocumentElement().getNodeName().equals(OPERATION_MAP_ELEMENT)) {
                this.m_operationMappingInfo = doc.getDocumentElement();
            }
        }
        catch (Exception e) {
            logger.severe("Failed to load pi4soa operation mapping information: " + e);
        }
    }

    public DefaultOperationMapper(Element info) {
        if (info != null && info.getNodeName().equals(OPERATION_MAP_ELEMENT)) {
            this.m_operationMappingInfo = info;
        }
    }

    public String getOperation(String messageType, String serviceType, Object message) {
        return this.getNameForMessageServiceType(messageType, serviceType, message, OPERATION_ELEMENT);
    }

    public String getFault(String messageType, String serviceType, Object message) {
        return this.getNameForMessageServiceType(messageType, serviceType, message, FAULT_ELEMENT);
    }

    protected String getNameForMessageServiceType(String messageType, String serviceType, Object message, String nameType) {
        String ret = null;
        if (this.m_operationMappingInfo != null) {
            if (serviceType != null) {
                NodeList nl = this.m_operationMappingInfo.getElementsByTagName(SERVICE_TYPE_ELEMENT);
                Node node = null;
                int i = 0;
                while (ret == null && i < nl.getLength()) {
                    node = nl.item(i);
                    if (node instanceof Element && ((Element)node).getAttribute(NAME_ATTR).equals(serviceType)) {
                        ret = this.getNameForMessageType((Element)node, messageType, message, nameType);
                    }
                    ++i;
                }
            }
            if (ret == null) {
                ret = this.getNameForMessageType(this.m_operationMappingInfo, messageType, message, nameType);
            }
        }
        return ret;
    }

    protected String getNameForMessageType(Element elem, String messageType, Object message, String nameType) {
        String ret = null;
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (ret == null && i < nl.getLength()) {
            Element mtelem;
            Node node = nl.item(i);
            if (node.getNodeName().equals(nameType) && node instanceof Element && (mtelem = (Element)node).getAttribute(MESSAGE_TYPE_ATTR).equals(messageType)) {
                if (mtelem.hasAttribute(GUARD_ATTR)) {
                    String guard = mtelem.getAttribute(GUARD_ATTR);
                    Object val = this.m_xpathEvaluator.evaluate(message, guard, null);
                    if (val instanceof Boolean && ((Boolean)val).booleanValue()) {
                        ret = this.getName(mtelem, message);
                    }
                } else {
                    ret = this.getName(mtelem, message);
                }
            }
            ++i;
        }
        return ret;
    }

    protected String getName(Element elem, Object message) {
        String ret = null;
        if (elem.hasAttribute(EXPRESSION_ATTR)) {
            Object val = this.m_xpathEvaluator.evaluate(message, elem.getAttribute(EXPRESSION_ATTR), null);
            if (val instanceof String) {
                ret = (String)val;
            }
        } else {
            ret = elem.getAttribute(NAME_ATTR);
        }
        return ret;
    }
}

