/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.util;

import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.projection.BehaviorProjection;
import org.pi4soa.service.util.ServiceDescriptionManager;

public class DescriptionRetrievalUtil
implements Runnable {
    private static final Logger logger = Logger.getLogger("org.pi4soa.service.util");
    private static DescriptionRetrievalUtil m_instance = null;
    private static Thread m_internalThread = null;
    private boolean m_running = false;
    private List m_queue = new Vector();

    protected DescriptionRetrievalUtil() {
    }

    public static synchronized DescriptionRetrievalUtil instance() {
        if (m_instance == null) {
            m_instance = new DescriptionRetrievalUtil();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_running = true;
        while (true) {
            List list = this.m_queue;
            synchronized (list) {
                if (this.m_queue.size() > 0) {
                    DescriptionRetrievalJob job = (DescriptionRetrievalJob)this.m_queue.remove(0);
                    job.obtainDescription();
                }
                if (this.m_queue.size() == 0) {
                    try {
                        this.m_queue.wait(60000L);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to wait for description job queue", e);
                    }
                }
            }
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDescription getServiceDescription(InputStream is, String participantType) {
        DescriptionRetrievalJob job;
        if (!this.isRunning()) {
            m_internalThread = new Thread(this);
            m_internalThread.start();
            logger.warning("Started internal thread for retrieving descriptions - should ideally be controlled as part of an app server deployed service");
        }
        DescriptionRetrievalJob descriptionRetrievalJob = job = new DescriptionRetrievalJob(is, participantType);
        synchronized (descriptionRetrievalJob) {
            List list = this.m_queue;
            synchronized (list) {
                this.m_queue.add(job);
                this.m_queue.notifyAll();
            }
            try {
                job.wait(5000L);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to wait for service description", e);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Returning service description=" + job.getServiceDescription());
        }
        return job.getServiceDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package getCDLPackage(InputStream is) {
        DescriptionRetrievalJob job;
        if (!this.isRunning()) {
            m_internalThread = new Thread(this);
            m_internalThread.start();
            logger.warning("Started internal thread for retrieving descriptions - should ideally be controlled as part of an app server deployed service");
        }
        DescriptionRetrievalJob descriptionRetrievalJob = job = new DescriptionRetrievalJob(is);
        synchronized (descriptionRetrievalJob) {
            List list = this.m_queue;
            synchronized (list) {
                this.m_queue.add(job);
                this.m_queue.notifyAll();
            }
            try {
                job.wait(5000L);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to wait for service description", e);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Returning CDL package=" + job.getCDLPackage());
        }
        return job.getCDLPackage();
    }

    public class DescriptionRetrievalJob {
        private InputStream m_inputStream = null;
        private String m_participantType = null;
        private ServiceDescription m_serviceDescription = null;
        private Package m_cdlPackage = null;
        private boolean m_retrieveCDL = false;

        public DescriptionRetrievalJob(InputStream is, String participantType) {
            this.m_inputStream = is;
            this.m_participantType = participantType;
        }

        public DescriptionRetrievalJob(InputStream is) {
            this.m_inputStream = is;
            this.m_retrieveCDL = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void obtainDescription() {
            try {
                Object cdlpack;
                if (this.m_participantType == null) {
                    if (this.m_retrieveCDL) {
                        this.m_cdlPackage = CDLManager.load((InputStream)this.m_inputStream);
                    } else {
                        this.m_serviceDescription = ServiceDescriptionManager.load(this.m_inputStream);
                    }
                } else {
                    cdlpack = CDLManager.load((InputStream)this.m_inputStream);
                    if (cdlpack != null) {
                        ParticipantType partType = cdlpack.getParticipantType(this.m_participantType);
                        if (partType != null) {
                            this.m_serviceDescription = BehaviorProjection.projectServiceDescription(cdlpack, partType, null);
                        } else {
                            logger.severe("Choreography does not have a participant of type '" + this.m_participantType + "'");
                        }
                    } else {
                        logger.severe("Failed to obtained CDL description");
                    }
                }
                cdlpack = this;
                synchronized (cdlpack) {
                    this.notifyAll();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to obtain service description", e);
            }
        }

        public ServiceDescription getServiceDescription() {
            return this.m_serviceDescription;
        }

        public Package getCDLPackage() {
            return this.m_cdlPackage;
        }
    }
}

