/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.pi4soa.common.schema.SchemaManager;
import org.pi4soa.common.schema.SchemaManagerFactory;
import org.pi4soa.common.util.EMFUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorType;
import org.pi4soa.service.behavior.NameSpace;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.BehaviorPackageImpl;

public class ServiceDescriptionManager {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.util");

    public static ServiceDescription load(String path) throws ServiceException {
        InputStream is = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                is = new FileInputStream(f);
            } else if (!f.isAbsolute()) {
                is = ServiceDescriptionManager.class.getClassLoader().getResourceAsStream(path);
            }
            if (is == null) {
                throw new ServiceException("Failed to locate path '" + path + "'");
            }
        }
        catch (IOException ioe) {
            throw new ServiceException("Failed to open file '" + path + "'", ioe);
        }
        return ServiceDescriptionManager.load(is, path);
    }

    public static ServiceDescription load(InputStream is) throws ServiceException {
        return ServiceDescriptionManager.load(is, null);
    }

    protected static ServiceDescription load(InputStream is, String path) throws ServiceException {
        ServiceDescription ret = null;
        BehaviorPackage.eINSTANCE.getServiceDescription();
        BehaviorPackageImpl.init();
        XMIResourceImpl xmi = new XMIResourceImpl();
        if (path != null) {
            xmi.setURI(URI.createFileURI((String)path));
        }
        try {
            xmi.doLoad(is, xmi.getDefaultLoadOptions());
        }
        catch (IOException ioe) {
            throw new ServiceException("Failed to load XMI representation of the service description", ioe);
        }
        EList list = xmi.getContents();
        if (list.get(0) instanceof ServiceDescription) {
            ret = (ServiceDescription)list.get(0);
        }
        if (ret != null) {
            ret.initialize();
        }
        return ret;
    }

    public static void save(ServiceDescription sdesc, OutputStream os) throws ServiceException {
        ServiceDescriptionManager.save(sdesc, os, null);
    }

    public static void save(ServiceDescription sdesc, OutputStream os, String encoding) throws ServiceException {
        BehaviorPackage.eINSTANCE.getServiceDescription();
        BehaviorPackageImpl.init();
        sdesc = (ServiceDescription)EcoreUtil.copy((EObject)sdesc);
        EMFUtil.clearDanglingReferences((Object)sdesc);
        XMIResourceImpl xmi = new XMIResourceImpl();
        xmi.getContents().add((Object)sdesc);
        if (encoding != null) {
            xmi.setEncoding(encoding);
        }
        try {
            xmi.doSave(os, xmi.getDefaultSaveOptions());
        }
        catch (IOException ioe) {
            throw new ServiceException("Failed to save XMI representation of the service description", ioe);
        }
    }

    public static String getURIFragment(BehaviorType behaviorType) {
        String ret = null;
        URI uri = null;
        if (behaviorType instanceof EObject) {
            BehaviorType eObject = behaviorType;
            StringBuffer result = new StringBuffer("#//");
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            EObject container = eObject.eContainer();
            while (container != null) {
                uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment((EStructuralFeature)eObject.eContainmentFeature(), (EObject)eObject));
                eObject = container;
                container = eObject.eContainer();
            }
            int size = uriFragmentPath.size();
            if (size > 0) {
                int i = size - 1;
                while (true) {
                    result.append((String)uriFragmentPath.get(i));
                    if (i == 0) break;
                    result.append('/');
                    --i;
                }
            }
            uri = URI.createURI((String)result.toString());
        }
        if (uri != null) {
            ret = uri.fragment();
        }
        return ret;
    }

    public static BehaviorType getBehaviorType(ServiceDescription sdesc, String uriFragment) {
        BehaviorType ret = null;
        if (sdesc != null && uriFragment != null) {
            if (uriFragment.equals("//")) {
                ret = sdesc;
            } else if (sdesc.eResource() == null) {
                ResourceImpl resource = new ResourceImpl();
                resource.getContents().add((Object)sdesc);
                ret = (BehaviorType)resource.getEObject(uriFragment);
            } else {
                ret = (BehaviorType)sdesc.eResource().getEObject(uriFragment);
            }
        }
        return ret;
    }

    public static SchemaManager getSchemaManager(BehaviorType behaviorType) {
        SchemaManager ret = SchemaManagerFactory.createSchemaManager();
        if (behaviorType != null) {
            int index;
            Resource resource = behaviorType.eResource();
            String path = null;
            if (resource != null && resource.getURI() != null && (index = (path = resource.getURI().toFileString()).lastIndexOf(File.separatorChar)) != -1) {
                path = path.substring(0, index);
            }
            ServiceDescription sdesc = behaviorType.getServiceDescription();
            for (NameSpace ns : sdesc.getNameSpaces()) {
                if (!NamesUtil.isSet((String)ns.getSchemaLocation())) continue;
                try {
                    String schemaLocation = ns.getSchemaLocation();
                    if (schemaLocation.indexOf(58) == -1 && schemaLocation.charAt(0) != File.separatorChar) {
                        schemaLocation = String.valueOf(path) + File.separatorChar + schemaLocation;
                        schemaLocation = URI.createFileURI((String)schemaLocation).toString();
                    }
                    ret.registerSchema(schemaLocation);
                }
                catch (Exception e) {
                    logger.fine("Unable to load schema '" + ns.getSchemaLocation() + "': " + e);
                }
            }
        }
        return ret;
    }
}

