/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.util;

import java.util.Iterator;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.Assign;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.CompletionHandler;
import org.pi4soa.service.behavior.Conditional;
import org.pi4soa.service.behavior.DefaultBehaviorVisitor;
import org.pi4soa.service.behavior.ExceptionHandler;
import org.pi4soa.service.behavior.Finalize;
import org.pi4soa.service.behavior.Perform;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.VariableBinding;
import org.pi4soa.service.behavior.VariableDeclaration;
import org.pi4soa.service.behavior.When;
import org.pi4soa.service.behavior.While;

public class VariableDeclarationUtil {
    public static boolean isVariableUsed(VariableDeclaration var) {
        boolean ret = false;
        if (var != null) {
            VariableUsageVisitor visitor = new VariableUsageVisitor(var);
            BehaviorDescription bd = var.getEnclosingBehaviorDescription();
            int i = 0;
            while (!visitor.isVariableUsed() && i < bd.getActivityTypes().size()) {
                ActivityType act = (ActivityType)bd.getActivityTypes().get(i);
                act.visit(visitor);
                ++i;
            }
            i = 0;
            while (!visitor.isVariableUsed() && i < bd.getCompletionHandlers().size()) {
                CompletionHandler ch = (CompletionHandler)bd.getCompletionHandlers().get(i);
                ch.visit(visitor);
                ++i;
            }
            i = 0;
            while (!visitor.isVariableUsed() && i < bd.getExceptionHandlers().size()) {
                ExceptionHandler eh = (ExceptionHandler)bd.getExceptionHandlers().get(i);
                eh.visit(visitor);
                ++i;
            }
            ret = visitor.isVariableUsed();
        }
        return ret;
    }

    static class VariableUsageVisitor
    extends DefaultBehaviorVisitor {
        private VariableDeclaration m_variable = null;
        private boolean m_used = false;

        public VariableUsageVisitor(VariableDeclaration var) {
            this.m_variable = var;
        }

        public boolean isVariableUsed() {
            return this.m_used;
        }

        public void assign(Assign elem) {
            this.checkExpression(elem.getExpression());
            if (elem.getVariable() == this.m_variable) {
                this.m_used = true;
            }
        }

        public void conditionalStart(Conditional elem) {
            this.checkExpression(elem.getExpression());
        }

        public void finalize(Finalize elem) {
            this.checkExpression(elem.getInstanceId());
        }

        public void perform(Perform elem) {
            this.checkExpression(elem.getInstanceId());
            Iterator iter = elem.getVariableBindings().iterator();
            while (!this.isVariableUsed() && iter.hasNext()) {
                VariableBinding vb = (VariableBinding)iter.next();
                if (vb.getParentVariable() != this.m_variable) continue;
                this.m_used = true;
            }
        }

        public void receive(Receive elem) {
            if (elem.getVariable() == this.m_variable) {
                this.m_used = true;
            }
        }

        public void send(Send elem) {
            if (elem.getVariable() == this.m_variable) {
                this.m_used = true;
            }
        }

        public void whenStart(When elem) {
            this.checkExpression(elem.getExpression());
            this.checkExpression(elem.getReEvaluateExpression());
        }

        public void whileStart(While elem) {
            this.checkExpression(elem.getExpression());
            this.checkExpression(elem.getReEvaluateExpression());
        }

        protected void checkExpression(String expr) {
            if (NamesUtil.isSet((String)expr) && expr.indexOf(this.m_variable.getName()) != -1) {
                this.m_used = true;
            }
        }
    }
}

