/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertMicroblog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.ResultState;
import org.rhq.enterprise.server.plugin.pc.alert.SenderResult;
import org.rhq.enterprise.server.util.LookupUtil;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class MicroblogSender
extends AlertSender {
    private final Log log = LogFactory.getLog(MicroblogSender.class);

    public SenderResult send(Alert alert) {
        SenderResult result;
        String user = this.preferences.getSimpleValue("user", null);
        String password = this.preferences.getSimpleValue("password", null);
        String baseUrl = this.preferences.getSimpleValue("microblogServerUrl", "http://twitter.com/api/");
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        Twitter twitter = new Twitter(user, password, baseUrl);
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        twitter.setSource("Jopr");
        StringBuilder b = new StringBuilder("Alert: '");
        b.append(alert.getAlertDefinition().getResource().getName());
        b.append("' (");
        b.append(alert.getAlertDefinition().getResource().getId());
        b.append("): ");
        b.append(alertManager.prettyPrintAlertConditions(alert));
        b.append("-by @JBossJopr");
        try {
            twitter.updateStatus(b.toString());
            result = new SenderResult(ResultState.SUCCESS, "Send notification to " + baseUrl + " as user " + user);
        }
        catch (TwitterException e) {
            this.log.warn((Object)"Notification via Microblog failed: ", (Throwable)e);
            result = new SenderResult(ResultState.FAILURE, "Sending failed :" + e.getMessage());
        }
        return result;
    }
}

