/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertMicroblog;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.util.LookupUtil;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;

public class MicroblogSender
extends AlertSender {
    static final String CONS_KEY = "iXCqk1vR2vKksDHkulZQ";
    static final String CONS_SECRET = "d2iwloVgHSghDfEmPWzjxAKdtp18TEvcBJsyaqBjst0";
    private final Log log = LogFactory.getLog(MicroblogSender.class);

    public SenderResult send(Alert alert) {
        SenderResult result;
        String consumerKey = this.preferences.getSimpleValue("consumerKey", CONS_KEY);
        String consumerSecret = this.preferences.getSimpleValue("consumerSecret", CONS_SECRET);
        String accessTokenFilePath = this.preferences.getSimpleValue("accessTokenFilePath", "/path/to/token.ser");
        try {
            TwitterFactory tFactory = new TwitterFactory();
            AccessToken accessToken = this.restoreAccessToken(accessTokenFilePath);
            this.log.debug((Object)("loading accessToken from " + accessTokenFilePath));
            this.log.debug((Object)("token: [" + accessToken.getToken() + "]"));
            this.log.debug((Object)("tokenSecret: [" + accessToken.getTokenSecret() + "]"));
            Twitter twitter = tFactory.getInstance();
            twitter.setOAuthConsumer(consumerKey, consumerSecret);
            twitter.setOAuthAccessToken(accessToken);
            AlertManagerLocal alertManager = LookupUtil.getAlertManager();
            StringBuilder b = new StringBuilder("Alert ");
            b.append(alert.getId()).append(":'");
            b.append(alert.getAlertDefinition().getResource().getName());
            b.append("' (");
            b.append(alert.getAlertDefinition().getResource().getId());
            b.append("): ");
            b.append(alertManager.prettyPrintAlertConditions(alert, true));
            b.append("-by " + this.alertParameters.getSimpleValue("twittedBy", "@RHQ"));
            String msg = b.toString();
            if (msg.length() > 140) {
                msg = msg.substring(0, 140);
            }
            Status status = twitter.updateStatus(msg);
            result = SenderResult.getSimpleSuccess((String)("Send notification - msg-id: " + status.getId()));
        }
        catch (TwitterException e) {
            this.log.warn((Object)"Notification via Microblog failed!", (Throwable)e);
            result = SenderResult.getSimpleFailure((String)("Sending failed :" + e.getMessage()));
        }
        catch (IOException e) {
            this.log.error((Object)"Notification via Microblog failed!", (Throwable)e);
            result = SenderResult.getSimpleFailure((String)("Sending failed :" + e.getMessage()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessToken restoreAccessToken(String tokenFilePath) throws IOException {
        FileInputStream file = new FileInputStream(tokenFilePath);
        BufferedInputStream buffer = new BufferedInputStream(file);
        ObjectInputStream input = new ObjectInputStream(buffer);
        AccessToken token = null;
        try {
            token = (AccessToken)input.readObject();
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"Erro reading token from disk: ", (Throwable)e);
        }
        finally {
            input.close();
        }
        return token;
    }
}

