/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
public class OperationsBackingBean
extends CustomAlertSenderBackingBean {
    private final Log log = LogFactory.getLog(OperationsBackingBean.class);
    private String resMode;
    private String tokenMode;
    Integer resId;
    private Integer operationId;
    private Map<String, Integer> operationIds = new HashMap<String, Integer>();
    private String resourceName;
    private ConfigurationDefinition configurationDefinition;
    private Configuration configuration;
    private static final String ALERT_NOTIFICATIONS = "ALERT_NOTIFICATIONS";
    private String operationName;

    public OperationsBackingBean() {
        this.log.info((Object)("new " + ((Object)((Object)this)).hashCode()));
    }

    public void internalCleanup() {
        Integer paramId;
        this.log.info((Object)"internalCleanup");
        PropertySimple parameterConfigProp = this.alertParameters.getSimple("parametersConfig");
        if (parameterConfigProp != null && (paramId = parameterConfigProp.getIntegerValue()) != null) {
            ConfigurationManagerLocal cmgr = LookupUtil.getConfigurationManager();
            cmgr.deleteConfigurations(Arrays.asList(paramId));
            this.cleanProperty(this.alertParameters, "parametersConfig");
        }
    }

    public String selectResource() {
        this.log.info((Object)("In select Resource, resId is " + this.resId + " resMode is " + this.resMode));
        if (this.resId != null) {
            this.persistProperty(this.alertParameters, "resourceId", this.resId);
            this.cleanProperty(this.alertParameters, "operationName");
            this.cleanProperty(this.alertParameters, "usable");
            this.operationIds = new HashMap<String, Integer>();
            this.operationId = null;
            this.operationName = null;
        }
        this.obtainOperationIds();
        return ALERT_NOTIFICATIONS;
    }

    public String selectOperation() {
        this.log.info((Object)("In selectOperation, resId is " + this.resId + " opName is " + this.operationId));
        if (this.operationId != null) {
            this.persistProperty(this.alertParameters, "operationName", this.operationId);
            this.getOperationNameFromOperationIds();
            this.lookupConfiguration();
        }
        return ALERT_NOTIFICATIONS;
    }

    private void lookupConfiguration() {
        try {
            OperationManagerLocal opMan = LookupUtil.getOperationManager();
            this.obtainOperationIds();
            if (this.operationId != null) {
                OperationDefinition operationDefinition = opMan.getOperationDefinition(this.webUser, this.operationId.intValue());
                this.configurationDefinition = operationDefinition.getParametersConfigurationDefinition();
                ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
                this.configuration = configurationManager.getConfigurationFromDefaultTemplate(this.configurationDefinition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String useConfiguration() {
        this.log.info((Object)("In useConfiguration, Configuration is " + this.configuration));
        super.persistConfiguration(this.configuration);
        this.persistProperty(this.alertParameters, "parametersConfig", this.configuration.getId());
        this.persistProperty(this.alertParameters, "usable", true);
        return ALERT_NOTIFICATIONS;
    }

    private void obtainOperationIds() {
        PropertySimple prop = this.alertParameters.getSimple("resourceId");
        if (prop != null) {
            this.resId = prop.getIntegerValue();
        }
        if (this.resId != null) {
            OperationManagerLocal opMan = LookupUtil.getOperationManager();
            List opDefs = opMan.findSupportedResourceOperations(this.webUser, this.resId.intValue(), false);
            for (OperationDefinition def : opDefs) {
                this.operationIds.put(def.getDisplayName(), def.getId());
            }
        }
    }

    public String getResMode() {
        return this.resMode;
    }

    public void setResMode(String resMode) {
        this.resMode = resMode;
    }

    public Integer getResId() {
        PropertySimple prop;
        if (this.resId == null && (prop = this.alertParameters.getSimple("resourceId")) != null) {
            this.resId = prop.getIntegerValue();
        }
        return this.resId;
    }

    public void setResId(Integer resId) {
        this.resId = resId;
        if (resId != null) {
            this.persistProperty(this.alertParameters, "resourceId", resId);
        }
    }

    public String getResourceName() {
        if (this.resId == null) {
            this.getResId();
        }
        if (this.resId != null) {
            ResourceManagerLocal resMgr = LookupUtil.getResourceManager();
            Resource res = resMgr.getResource(this.webUser, this.resId.intValue());
            this.resourceName = res.getName() + " (" + res.getResourceType().getName() + ")";
        }
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getOperationId() {
        PropertySimple prop;
        System.out.println("OperationsBackingBean.getOperationId, operationId=" + this.operationId);
        if (this.operationId == null && (prop = this.alertParameters.getSimple("operationName")) != null) {
            this.operationId = prop.getIntegerValue();
        }
        if (this.operationIds == null || this.operationIds.isEmpty()) {
            this.obtainOperationIds();
        }
        this.getOperationNameFromOperationIds();
        return this.operationId;
    }

    private void getOperationNameFromOperationIds() {
        for (Map.Entry<String, Integer> ent : this.operationIds.entrySet()) {
            if (!ent.getValue().equals(this.operationId)) continue;
            this.operationName = ent.getKey();
        }
    }

    public void setOperationId(Integer operationId) {
        this.operationId = operationId;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Map<String, Integer> getOperationIds() {
        this.obtainOperationIds();
        return this.operationIds;
    }

    public void setOperationIds(Map<String, Integer> operationIds) {
        this.operationIds = operationIds;
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        if (this.configurationDefinition == null) {
            this.lookupConfiguration();
        }
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getNullConfigurationDefinitionMessage() {
        return "This operation does not take any parameters.";
    }

    public String getNullConfigurationMessage() {
        return "This operation parameters definition has not been initialized.";
    }

    public String getTokenMode() {
        PropertySimple prop;
        if (this.tokenMode == null && (prop = this.alertParameters.getSimple("tokenMode")) != null) {
            this.tokenMode = prop.getStringValue();
        }
        return this.tokenMode;
    }

    public void setTokenMode(String tokenMode) {
        this.tokenMode = tokenMode;
        this.persistProperty(this.alertParameters, "tokenMode", tokenMode);
    }
}

