/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.exception.ScheduleException;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertOperations.AlertTokenReplacer;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Scope(value=ScopeType.PAGE)
public class OperationsSender
extends AlertSender {
    private final Log log = LogFactory.getLog(OperationsSender.class);
    static final String RESOURCE_ID = "resourceId";
    static final String OPERATION_ID = "operationName";
    static final String USABLE = "usable";
    protected static final String TOKEN_MODE = "tokenMode";
    private static final String LITERAL = "literal";
    private static final String INTERPRETED = "interpreted";
    public static final String PARAMETERS_CONFIG = "parametersConfig";

    public SenderResult send(Alert alert) {
        ResourceOperationSchedule sched;
        Integer paramId;
        PropertySimple resProp = this.alertParameters.getSimple(RESOURCE_ID);
        PropertySimple opIdProp = this.alertParameters.getSimple(OPERATION_ID);
        if (resProp == null || resProp.getIntegerValue() == null || opIdProp == null || opIdProp.getStringValue() == null) {
            return new SenderResult(ResultState.FAILURE, "Not enough parameters given");
        }
        PropertySimple usableProp = this.alertParameters.getSimple(USABLE);
        if (usableProp == null || usableProp.getBooleanValue() == null || !usableProp.getBooleanValue().booleanValue()) {
            return new SenderResult(ResultState.FAILURE, "Not yet configured");
        }
        Integer resourceId = resProp.getIntegerValue();
        Integer opId = opIdProp.getIntegerValue();
        String opName = null;
        OperationManagerLocal opMgr = LookupUtil.getOperationManager();
        Subject subject = LookupUtil.getSubjectManager().getOverlord();
        List opdefs = opMgr.findSupportedResourceOperations(subject, resourceId.intValue(), false);
        OperationDefinition opDef = null;
        for (OperationDefinition tmp : opdefs) {
            if (tmp.getId() != opId.intValue()) continue;
            opName = tmp.getName();
            opDef = tmp;
            break;
        }
        if (opName == null) {
            return new SenderResult(ResultState.FAILURE, "No operation found ");
        }
        PropertySimple parameterConfigProp = this.alertParameters.getSimple(PARAMETERS_CONFIG);
        Configuration parameters = null;
        if (parameterConfigProp != null && (paramId = parameterConfigProp.getIntegerValue()) != null) {
            ConfigurationManagerLocal cmgr = LookupUtil.getConfigurationManager();
            parameters = cmgr.getConfiguration(subject, paramId.intValue());
        }
        String tokenMode = this.alertParameters.getSimpleValue(TOKEN_MODE, LITERAL);
        Configuration theParameters = null;
        try {
            if (parameters != null && tokenMode.equals(INTERPRETED)) {
                theParameters = parameters.deepCopy(false);
                Map propsMap = theParameters.getSimpleProperties();
                if (!propsMap.isEmpty()) {
                    ResourceManagerLocal resMgr = LookupUtil.getResourceManager();
                    Resource targetResource = resMgr.getResource(subject, resourceId.intValue());
                    AlertTokenReplacer tr = new AlertTokenReplacer(alert, opDef, targetResource);
                    for (PropertySimple prop : propsMap.values()) {
                        String tmp = prop.getStringValue();
                        tmp = tr.replaceTokens(tmp);
                        prop.setStringValue(tmp);
                    }
                }
            } else {
                theParameters = parameters;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sched = opMgr.scheduleResourceOperation(subject, resourceId.intValue(), opName, 0L, 0L, 0, 0, theParameters, "Alert operation for " + alert.getAlertDefinition().getName());
        }
        catch (ScheduleException e) {
            return new SenderResult(ResultState.FAILURE, "Scheduling of operation " + opName + " on resource " + resourceId + " failed: " + e.getMessage());
        }
        return new SenderResult(ResultState.SUCCESS, "Scheduled operation " + opName + " on resource " + resourceId + " with jobId " + sched.getJobId());
    }
}

