/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.plugins.alertOperations.OperationInfo;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationsBackingBean
extends CustomAlertSenderBackingBean {
    private Map<String, String> selectionModeOptions = new LinkedHashMap<String, String>();
    private Map<String, String> ancestorTypeOptions = new LinkedHashMap<String, String>();
    private Map<String, String> descendantTypeOptions = new LinkedHashMap<String, String>();
    private Map<String, String> operationNameOptions = new LinkedHashMap<String, String>();
    private String selectionMode = "";
    private String resourceId;
    private String ancestorTypeId;
    private String descendantName;
    private String descendantTypeId;
    private String operationDefinitionId;
    private String effectiveResourceTypeName;
    private String effectiveResourceTypeId;
    private ConfigurationDefinition argumentsConfigurationDefinition;
    private Configuration argumentsConfiguration;
    private Subject overlord;

    private Subject getOverlord() {
        if (this.overlord == null) {
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
        }
        return this.overlord;
    }

    public void loadView() {
        this.selectionMode = this.get(OperationInfo.Constants.SELECTION_MODE, "none");
        for (OperationInfo.ResourceSelectionMode mode : OperationInfo.ResourceSelectionMode.values()) {
            this.selectionModeOptions.put(mode.displayString, mode.name());
        }
        String argumentsConfigurationId = this.get(OperationInfo.Constants.ARGUMENTS_CONFIG_ID, null);
        Configuration previousArguments = null;
        if (argumentsConfigurationId != null && !argumentsConfigurationId.equals("none")) {
            previousArguments = LookupUtil.getConfigurationManager().getConfiguration(this.getOverlord(), Integer.parseInt(argumentsConfigurationId));
        }
        if (this.selectionMode.equals("none")) {
            return;
        }
        if (this.selectionMode.equals(OperationInfo.ResourceSelectionMode.SPECIFIC.name())) {
            this.resourceId = this.get(OperationInfo.Constants.SPECIFIC_RESOURCE_ID, "");
        } else if (this.selectionMode.equals(OperationInfo.ResourceSelectionMode.RELATIVE.name())) {
            List descendants;
            this.ancestorTypeId = this.get(OperationInfo.Constants.RELATIVE_ANCESTOR_TYPE_ID, "none");
            this.descendantName = this.get(OperationInfo.Constants.RELATIVE_DESCENDANT_NAME, "Name (optional)");
            this.descendantTypeId = this.get(OperationInfo.Constants.RELATIVE_DESCENDANT_TYPE_ID, "none");
            ResourceType contextType = this.computeResourceTypeFromContext();
            ArrayList<ResourceType> ancestors = null;
            if (this.context.equals("resource")) {
                try {
                    List ancestry = LookupUtil.getResourceManager().getResourceLineage(Integer.parseInt(this.contextSubId));
                    ancestors = new ArrayList<ResourceType>();
                    for (Resource next : ancestry) {
                        ancestors.add(next.getResourceType());
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (ancestors == null) {
                ancestors = LookupUtil.getResourceTypeManager().getResourceTypeAncestorsWithOperations(this.getOverlord(), contextType.getId());
            }
            this.load(this.ancestorTypeOptions, ancestors);
            if (!this.ancestorTypeId.equals("none")) {
                descendants = LookupUtil.getResourceTypeManager().getResourceTypeDescendantsWithOperations(this.getOverlord(), Integer.parseInt(this.ancestorTypeId));
                this.load(this.descendantTypeOptions, descendants);
            } else {
                descendants = LookupUtil.getResourceTypeManager().getResourceTypeDescendantsWithOperations(this.getOverlord(), contextType.getId());
                this.load(this.descendantTypeOptions, descendants);
            }
        }
        ResourceType type = null;
        if (this.selectionMode.equals(OperationInfo.ResourceSelectionMode.SELF.name())) {
            type = this.computeResourceTypeFromContext();
        } else if (this.selectionMode.equals(OperationInfo.ResourceSelectionMode.SPECIFIC.name())) {
            if (!this.resourceId.equals("")) {
                Resource resource = LookupUtil.getResourceManager().getResource(this.getOverlord(), Integer.parseInt(this.resourceId));
                type = resource.getResourceType();
            }
        } else if (this.selectionMode.equals(OperationInfo.ResourceSelectionMode.RELATIVE.name())) {
            try {
                if (!this.descendantTypeId.equals("none")) {
                    type = LookupUtil.getResourceTypeManager().getResourceTypeById(this.getOverlord(), Integer.parseInt(this.descendantTypeId));
                } else if (!this.ancestorTypeId.equals("none")) {
                    type = LookupUtil.getResourceTypeManager().getResourceTypeById(this.getOverlord(), Integer.parseInt(this.ancestorTypeId));
                }
            }
            catch (ResourceTypeNotFoundException rtnfe) {
                // empty catch block
            }
        }
        if (type == null) {
            return;
        }
        this.effectiveResourceTypeId = String.valueOf(type.getId());
        this.effectiveResourceTypeName = type.getName();
        this.operationDefinitionId = this.get(OperationInfo.Constants.OPERATION_ID, "none");
        List definitions = LookupUtil.getOperationManager().findSupportedResourceTypeOperations(this.getOverlord(), Integer.valueOf(this.effectiveResourceTypeId).intValue(), false);
        for (OperationDefinition nextDefinition : definitions) {
            this.operationNameOptions.put(nextDefinition.getDisplayName(), String.valueOf(nextDefinition.getId()));
        }
        if (this.operationDefinitionId.equals("none")) {
            return;
        }
        try {
            OperationDefinition operation = LookupUtil.getOperationManager().getOperationDefinition(this.getOverlord(), Integer.parseInt(this.operationDefinitionId));
            this.argumentsConfigurationDefinition = operation.getParametersConfigurationDefinition();
            if (this.argumentsConfigurationDefinition == null) {
                return;
            }
            if (previousArguments == null) {
                Configuration emptyConfiguration = LookupUtil.getConfigurationManager().getConfigurationFromDefaultTemplate(this.argumentsConfigurationDefinition);
                this.argumentsConfiguration = emptyConfiguration.deepCopy(false);
            } else {
                this.argumentsConfiguration = previousArguments;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load(Map<String, String> resourceTypeOptions, List<ResourceType> types) {
        for (ResourceType nextType : types) {
            resourceTypeOptions.put(nextType.getName(), String.valueOf(nextType.getId()));
        }
    }

    private ResourceType computeResourceTypeFromContext() {
        AlertDefinition definition = LookupUtil.getAlertDefinitionManager().getAlertDefinitionById(this.getOverlord(), Integer.parseInt(this.contextId));
        ResourceType type = null;
        type = definition.getResource() != null ? definition.getResource().getResourceType() : (definition.getResourceGroup() != null ? definition.getResourceGroup().getResourceType() : definition.getResourceType());
        return type;
    }

    private String get(OperationInfo.Constants operationInfoConstant, String defaultValue) {
        return this.alertParameters.getSimpleValue(operationInfoConstant.propertyName, defaultValue);
    }

    public void internalCleanup() {
        this.cleanupPreviousArguments();
    }

    public void saveView() {
        this.set(this.selectionMode, OperationInfo.Constants.SELECTION_MODE);
        this.set(this.resourceId, OperationInfo.Constants.SPECIFIC_RESOURCE_ID);
        this.set(this.ancestorTypeId, OperationInfo.Constants.RELATIVE_ANCESTOR_TYPE_ID);
        this.set("Name (optional)".equals(this.descendantName) ? null : this.descendantName, OperationInfo.Constants.RELATIVE_DESCENDANT_NAME);
        this.set(this.descendantTypeId, OperationInfo.Constants.RELATIVE_DESCENDANT_TYPE_ID);
        this.set(this.operationDefinitionId, OperationInfo.Constants.OPERATION_ID);
        this.cleanupPreviousArguments();
        if (this.operationDefinitionId != null && !this.operationDefinitionId.equals("none") && this.argumentsConfiguration != null) {
            this.argumentsConfiguration.setId(0);
            this.argumentsConfiguration = this.persistConfiguration(this.argumentsConfiguration);
            this.set(String.valueOf(this.argumentsConfiguration.getId()), OperationInfo.Constants.ARGUMENTS_CONFIG_ID);
        }
        this.alertParameters = this.persistConfiguration(this.alertParameters);
    }

    private void cleanupPreviousArguments() {
        String previousArgumentsConfigurationId = this.get(OperationInfo.Constants.ARGUMENTS_CONFIG_ID, null);
        this.set(null, OperationInfo.Constants.ARGUMENTS_CONFIG_ID);
        if (previousArgumentsConfigurationId != null && !previousArgumentsConfigurationId.equals("none")) {
            LookupUtil.getConfigurationManager().deleteConfigurations(Arrays.asList(Integer.parseInt(previousArgumentsConfigurationId)));
        }
    }

    private boolean set(String value, OperationInfo.Constants operationInfoConstant) {
        String propertyName = operationInfoConstant.propertyName;
        if (value == null) {
            Property previous = this.alertParameters.remove(propertyName);
            if (previous == null) {
                return false;
            }
            return ((PropertySimple)previous).getStringValue() != null;
        }
        PropertySimple property = this.alertParameters.getSimple(propertyName);
        if (property == null) {
            property = new PropertySimple(propertyName, (Object)value);
            this.alertParameters.put((Property)property);
            return true;
        }
        String oldStringValue = property.getStringValue();
        property.setStringValue(value);
        return !value.equals(oldStringValue);
    }

    public Map<String, String> getSelectionModeOptions() {
        return this.selectionModeOptions;
    }

    public Map<String, String> getAncestorTypeOptions() {
        return this.ancestorTypeOptions;
    }

    public Map<String, String> getDescendantTypeOptions() {
        return this.descendantTypeOptions;
    }

    public Map<String, String> getOperationNameOptions() {
        return this.operationNameOptions;
    }

    public String getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(String selectionMode) {
        this.selectionMode = selectionMode;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getAncestorTypeId() {
        return this.ancestorTypeId;
    }

    public void setAncestorTypeId(String ancestorTypeId) {
        this.ancestorTypeId = ancestorTypeId;
    }

    public String getDescendantName() {
        return this.descendantName;
    }

    public void setDescendantName(String descendantName) {
        this.descendantName = descendantName;
    }

    public String getDescendantTypeId() {
        return this.descendantTypeId;
    }

    public void setDescendantTypeId(String descendantTypeId) {
        this.descendantTypeId = descendantTypeId;
    }

    public String getOperationDefinitionId() {
        return this.operationDefinitionId;
    }

    public void setOperationDefinitionId(String operationDefinitionId) {
        this.operationDefinitionId = operationDefinitionId;
    }

    public String getEffectiveResourceTypeId() {
        return this.effectiveResourceTypeId;
    }

    public String getEffectiveResourceTypeName() {
        return this.effectiveResourceTypeName;
    }

    public ConfigurationDefinition getArgumentsConfigurationDefinition() {
        return this.argumentsConfigurationDefinition;
    }

    public void setArgumentsConfigurationDefinition(ConfigurationDefinition argumentsConfigurationDefinition) {
        this.argumentsConfigurationDefinition = argumentsConfigurationDefinition;
    }

    public Configuration getArgumentsConfiguration() {
        return this.argumentsConfiguration;
    }

    public void setArgumentsConfiguration(Configuration argumentsConfiguration) {
        this.argumentsConfiguration = argumentsConfiguration;
    }

    public String getNoParametersMessage() {
        return "This operation does not take any parameters.";
    }

    public String getNotInitializedMessage() {
        return "This operation parameters definition has not been initialized.";
    }
}

