/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.exception.ScheduleException;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertOperations.AlertTokenReplacer;
import org.rhq.enterprise.server.plugins.alertOperations.OperationInfo;
import org.rhq.enterprise.server.util.LookupUtil;

public class OperationsSender
extends AlertSender {
    public SenderResult send(Alert alert) {
        OperationInfo info = OperationInfo.load(this.alertParameters);
        if (info.error != null) {
            return new SenderResult(ResultState.FAILURE, info.error);
        }
        Subject subject = LookupUtil.getSubjectManager().getOverlord();
        OperationDefinition operation = info.getOperationDefinition();
        Configuration parameters = info.getArguments();
        Configuration replacedParameters = null;
        try {
            if (parameters != null) {
                replacedParameters = parameters.deepCopy(false);
                Resource resource = LookupUtil.getResourceManager().getResource(subject, info.resourceId.intValue());
                AlertTokenReplacer replacementEngine = new AlertTokenReplacer(alert, operation, resource);
                for (PropertySimple simpleProperty : replacedParameters.getSimpleProperties().values()) {
                    String temp = simpleProperty.getStringValue();
                    temp = replacementEngine.replaceTokens(temp);
                    simpleProperty.setStringValue(temp);
                }
            }
        }
        catch (Exception e) {
            String message = this.getResultMessage(operation.getName(), info.resourceId, "failed with " + e.getMessage());
            return new SenderResult(ResultState.FAILURE, message);
        }
        try {
            Resource targetResource = info.getTargetResource(alert);
            String description = "Alert operation for " + alert.getAlertDefinition().getName();
            ResourceOperationSchedule schedule = LookupUtil.getOperationManager().scheduleResourceOperation(subject, targetResource.getId(), operation.getName(), 0L, 0L, 0, 0, replacedParameters, description);
            String message = this.getResultMessage(operation.getName(), info.resourceId, "jobId was " + schedule.getJobId());
            return new SenderResult(ResultState.SUCCESS, message);
        }
        catch (ScheduleException e) {
            String message = this.getResultMessage(operation.getName(), info.resourceId, "failed with " + e.getMessage());
            return new SenderResult(ResultState.FAILURE, message);
        }
    }

    private String getResultMessage(String operationName, int resourceId, String details) {
        return operationName + " scheduled on resource " + resourceId + ": " + details;
    }

    public String previewConfiguration() {
        OperationInfo info = OperationInfo.load(this.alertParameters);
        return info.toString();
    }
}

