/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.plugins.alertOperations.Token;
import org.rhq.enterprise.server.plugins.alertOperations.TokenClass;

public class PrintTokens {
    private final Log log = LogFactory.getLog(PrintTokens.class);
    private static final String CLOSE = "\">\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BufferedOutputStream out;
        if (args.length == 0) {
            out = new BufferedOutputStream(System.out);
        } else {
            File file = new File(args[0]);
            System.err.println("writing to " + file.getAbsolutePath());
            out = new BufferedOutputStream(new FileOutputStream(file));
        }
        try {
            String text = PrintTokens.createTokenDescription();
            ((OutputStream)out).write(text.getBytes());
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static String createTokenDescription() {
        EnumSet<TokenClass> tokenClasses = EnumSet.allOf(TokenClass.class);
        StringBuilder builder = new StringBuilder("<tokenClasses>\n");
        for (TokenClass tc : tokenClasses) {
            builder.append("  <tokenClass name=\"").append(tc.getText()).append("\"").append(" description=\"").append(tc.getDescription()).append(CLOSE);
            Set<Token> tokens = Token.getByTokenClass(tc);
            for (Token token : tokens) {
                builder.append("    <token name=\"").append(token.getName()).append(CLOSE);
                builder.append("      <fullName>").append(token.getText()).append("</fullName>\n");
                builder.append("      <descr>").append(token.getDescription()).append("</descr>\n");
                builder.append("    </token>\n");
            }
            builder.append("  </tokenClass>\n");
        }
        builder.append("</tokenClasses>\n");
        return builder.toString();
    }
}

