/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import java.util.List;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.util.LookupUtil;

public class OperationInfo {
    public final ResourceSelectionMode mode;
    public final Integer resourceId;
    public final Integer ancestorTypeId;
    public final Integer descendantTypeId;
    public final String descendantName;
    public final Integer operationId;
    public final Configuration arguments;
    public final String error;
    private Subject overlord;

    private OperationInfo(String mode, String resourceId, String ancestorTypeId, String descendantTypeId, String descendantName, String operationId, Configuration arguments) {
        ResourceSelectionMode selectionMode = null;
        try {
            if (mode != null) {
                selectionMode = ResourceSelectionMode.valueOf(mode);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.mode = selectionMode;
        this.resourceId = this.get(resourceId);
        this.ancestorTypeId = this.get(ancestorTypeId);
        this.descendantTypeId = this.get(descendantTypeId);
        this.descendantName = descendantName;
        this.operationId = this.get(operationId);
        this.arguments = arguments;
        this.error = this.getErrorString();
    }

    private Integer get(String data) {
        if (data == null || data.equals("") || data.equals("none")) {
            return null;
        }
        return Integer.parseInt(data);
    }

    private String getErrorString() {
        if (this.mode == ResourceSelectionMode.RELATIVE) {
            if (this.ancestorTypeId == null) {
                return "<no 'start search from' selected>";
            }
        } else if (this.mode == ResourceSelectionMode.SPECIFIC && this.resourceId == null) {
            return "<no resource selected>";
        }
        if (this.operationId == null) {
            return "<no operation selected>";
        }
        return null;
    }

    public static OperationInfo load(Configuration configuration, Configuration extraConfiguration) {
        String mode = OperationInfo.get(configuration, Constants.SELECTION_MODE, null);
        String resourceId = OperationInfo.get(configuration, Constants.SPECIFIC_RESOURCE_ID, null);
        String ancestorTypeId = OperationInfo.get(configuration, Constants.RELATIVE_ANCESTOR_TYPE_ID, null);
        String descendantTypeId = OperationInfo.get(configuration, Constants.RELATIVE_DESCENDANT_TYPE_ID, null);
        String descendantName = OperationInfo.get(configuration, Constants.RELATIVE_DESCENDANT_NAME, null);
        String operationId = OperationInfo.get(configuration, Constants.OPERATION_ID, null);
        return new OperationInfo(mode, resourceId, ancestorTypeId, descendantTypeId, descendantName, operationId, extraConfiguration);
    }

    private static String get(Configuration configuration, Constants operationInfoConstants, String defaultValue) {
        return configuration.getSimpleValue(operationInfoConstants.propertyName, defaultValue);
    }

    public String toString() {
        String errorInfo = this.getErrorString();
        if (errorInfo != null) {
            return errorInfo;
        }
        String resourceInfo = this.getResourceInfo();
        OperationDefinition operation = this.getOperationDefinition();
        return "'" + operation.getDisplayName() + "' on " + resourceInfo;
    }

    public String getResourceInfo() {
        if (this.mode == null) {
            return null;
        }
        if (this.mode == ResourceSelectionMode.SELF) {
            return "this resource";
        }
        if (this.mode == ResourceSelectionMode.SPECIFIC) {
            if (this.resourceId == null) {
                return null;
            }
            List lineage = LookupUtil.getResourceManager().getResourceLineage(this.resourceId.intValue());
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (Resource next : lineage) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" > ");
                }
                builder.append(next.getName());
            }
            return "the ( " + builder.toString() + " ) resource";
        }
        if (this.mode == ResourceSelectionMode.RELATIVE) {
            ResourceType ancestor = this.getType(this.ancestorTypeId);
            ResourceType descendant = this.getType(this.descendantTypeId);
            StringBuilder builder = new StringBuilder();
            builder.append(" the ");
            if (descendant != null) {
                if (this.descendantName != null) {
                    builder.append('\'');
                    builder.append(this.descendantName);
                    builder.append('\'');
                }
                builder.append(' ');
                builder.append(descendant.getName());
                builder.append(" descendant");
                if (ancestor != null) {
                    builder.append(" under the ");
                }
            }
            if (ancestor != null) {
                builder.append(ancestor.getName());
                builder.append(" ancestor");
            }
            return builder.toString();
        }
        return "<unknown selection mode>";
    }

    public OperationDefinition getOperationDefinition() {
        OperationDefinition operation = LookupUtil.getOperationManager().getOperationDefinition(this.getOverlord(), this.operationId.intValue());
        return operation;
    }

    public Configuration getArguments() {
        return this.arguments;
    }

    public Resource getTargetResource(Alert alert) {
        if (this.mode == null) {
            return null;
        }
        if (this.mode == ResourceSelectionMode.SELF) {
            AlertDefinition definition = alert.getAlertDefinition();
            Resource contextResource = definition.getResource();
            return contextResource;
        }
        if (this.mode == ResourceSelectionMode.SPECIFIC) {
            return LookupUtil.getResourceManager().getResourceById(this.getOverlord(), this.resourceId.intValue());
        }
        if (this.mode == ResourceSelectionMode.RELATIVE) {
            Resource contextResource;
            AlertDefinition definition = alert.getAlertDefinition();
            Resource searchFrom = contextResource = definition.getResource();
            if (this.ancestorTypeId != null) {
                List contextLineage = LookupUtil.getResourceManager().getResourceLineage(contextResource.getId());
                for (Resource nextResource : contextLineage) {
                    if (nextResource.getResourceType().getId() != this.ancestorTypeId.intValue()) continue;
                    searchFrom = nextResource;
                    break;
                }
            }
            Resource targetResource = null;
            if (this.descendantTypeId != null) {
                List candidateResourceIds = LookupUtil.getResourceManager().getResourceDescendantsByTypeAndName(this.getOverlord(), searchFrom.getId(), this.descendantTypeId, this.descendantName);
                if (candidateResourceIds.size() == 0) {
                    throw new IllegalStateException("Could not find target resource");
                }
                if (candidateResourceIds.size() != 1) {
                    throw new IllegalStateException("Found multiple resources, need exactly one match");
                }
                int targetResourceId = (Integer)candidateResourceIds.get(0);
                targetResource = LookupUtil.getResourceManager().getResourceById(this.getOverlord(), targetResourceId);
            } else {
                targetResource = searchFrom;
            }
            return targetResource;
        }
        return null;
    }

    private Subject getOverlord() {
        if (this.overlord == null) {
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
        }
        return this.overlord;
    }

    private ResourceType getType(Integer typeId) {
        if (typeId == null) {
            return null;
        }
        try {
            return LookupUtil.getResourceTypeManager().getResourceTypeById(this.getOverlord(), typeId.intValue());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static enum ResourceSelectionMode {
        SELF("This Resource"),
        SPECIFIC("Specific Resource"),
        RELATIVE("Relative Resource");

        public final String displayString;

        private ResourceSelectionMode(String displayString) {
            this.displayString = displayString;
        }
    }

    public static enum Constants {
        SELECTION_MODE("selection-mode"),
        SPECIFIC_RESOURCE_ID("selection-specific-resource-id"),
        RELATIVE_ANCESTOR_TYPE_ID("selection-relative-ancestor-type-id"),
        RELATIVE_DESCENDANT_TYPE_ID("selection-relative-descendant-type-id"),
        RELATIVE_DESCENDANT_NAME("selection-relative-descendant-name"),
        OPERATION_ID("operation-definition-id");

        public final String propertyName;

        private Constants(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

