/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertRoles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Create;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.util.PageControl;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesBackingBean
extends CustomAlertSenderBackingBean {
    private final Log log = LogFactory.getLog(RolesBackingBean.class);
    private List<Role> allRoles;
    private Map<String, String> rolesMap;
    private List<String> currentRoles;
    private List<String> rolesToRemove;
    private static final String ROLE_ID = "roleId";
    private boolean isDebug = false;

    @Create
    public void init() {
        if (this.log.isDebugEnabled()) {
            this.isDebug = true;
        }
        this.getAllRoles();
        this.getSelectableRolesMap();
        this.fillRolesFromAlertParameters();
    }

    private void getAllRoles() {
        RoleManagerLocal mgr = LookupUtil.getRoleManager();
        this.allRoles = mgr.findRoles(new PageControl());
    }

    private void fillRolesFromAlertParameters() {
        String rolesString = this.alertParameters.getSimpleValue(ROLE_ID, "");
        String[] roles = rolesString.split(",");
        if (roles.length == 0) {
            return;
        }
        if (this.currentRoles == null) {
            this.currentRoles = new ArrayList<String>();
        }
        this.currentRoles.addAll(Arrays.asList(roles));
    }

    public List<String> getCurrentRoles() {
        if (this.currentRoles == null) {
            this.fillRolesFromAlertParameters();
        }
        return this.currentRoles;
    }

    public void setCurrentRoles(List<String> currentRoles) {
        this.currentRoles = currentRoles;
    }

    public List<String> getRolesToRemove() {
        return this.rolesToRemove;
    }

    public void setRolesToRemove(List<String> rolesToRemove) {
        this.rolesToRemove = rolesToRemove;
    }

    public Map<String, String> getSelectableRolesMap() {
        if (this.rolesMap == null) {
            this.rolesMap = new HashMap<String, String>();
            if (this.allRoles == null) {
                this.getAllRoles();
            }
            if (this.currentRoles == null) {
                this.fillRolesFromAlertParameters();
            }
            for (Role role : this.allRoles) {
                String roleId = String.valueOf(role.getId());
                if (this.currentRoles != null && this.currentRoles.contains(roleId)) continue;
                this.rolesMap.put(role.getName(), roleId);
            }
        }
        return this.rolesMap;
    }

    public Map<String, String> getCurrentRolesMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.currentRoles == null) {
            return ret;
        }
        for (Role role : this.allRoles) {
            String roleId = String.valueOf(role.getId());
            if (!this.currentRoles.contains(roleId)) continue;
            ret.put(role.getName(), roleId);
        }
        return ret;
    }

    public String addRoles() {
        PropertySimple p;
        if (this.isDebug) {
            this.log.debug((Object)("Selected roles:  " + this.currentRoles));
        }
        if (this.currentRoles.isEmpty()) {
            return "ALERT_NOTIFICATION";
        }
        String roles = "";
        for (String role : this.currentRoles) {
            roles = roles + role;
            roles = roles + ",";
        }
        if (roles.endsWith(",")) {
            roles = roles.substring(0, roles.length() - 1);
        }
        if ((p = this.alertParameters.getSimple(ROLE_ID)) == null) {
            p = new PropertySimple(ROLE_ID, (Object)roles);
            this.alertParameters.put((Property)p);
        } else {
            p.setStringValue(roles);
        }
        this.alertParameters = this.persistConfiguration(this.alertParameters);
        this.fillRolesFromAlertParameters();
        return "ALERT_NOTIFICATIONS";
    }

    public String removeRoles() {
        PropertySimple p;
        if (this.isDebug) {
            this.log.debug((Object)("In remove roles, " + this.rolesToRemove));
        }
        String roles = "";
        ArrayList<String> resulting = new ArrayList<String>(this.currentRoles);
        resulting.removeAll(this.rolesToRemove);
        for (String subject : resulting) {
            roles = roles + subject;
            roles = roles + ",";
        }
        if (roles.endsWith(",")) {
            roles = roles.substring(0, roles.length() - 1);
        }
        if ((p = this.alertParameters.getSimple(ROLE_ID)) == null) {
            if (!resulting.isEmpty()) {
                p = new PropertySimple(ROLE_ID, (Object)roles);
                this.alertParameters.put((Property)p);
            }
        } else {
            p.setStringValue(roles);
        }
        this.alertParameters = this.persistConfiguration(this.alertParameters);
        this.currentRoles = resulting;
        this.fillRolesFromAlertParameters();
        return "ALERT_NOTIFICATIONS";
    }
}

