/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster.config;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractConfigurationFile {
    private File configurationFile;
    private Document document;

    public AbstractConfigurationFile(String fileName) throws ParserConfigurationException, SAXException, IOException {
        this(new File(fileName));
    }

    public AbstractConfigurationFile(File configurationFile) throws ParserConfigurationException, SAXException, IOException {
        this.configurationFile = configurationFile;
        this.loadConfiguratonFile();
    }

    abstract void setPropertyValue(String var1, String var2);

    abstract String getPropertyValue(String var1);

    public Document getDocument() {
        return this.document;
    }

    public void saveConfigurationFile() throws Exception {
        StreamResult result = new StreamResult(this.configurationFile);
        DOMSource source = new DOMSource(this.getDocument());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    private void loadConfiguratonFile() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.document = docBuilder.parse(this.configurationFile);
    }
}

