/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.SigarProxy;
import org.rhq.core.system.SigarAccess;
import org.rhq.core.system.SystemInfoException;

public class FileSystemInfo {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String mountPoint;
    private FileSystem fs;
    private FileSystemUsage fsUsage;

    public FileSystemInfo(String mountPoint) {
        this.mountPoint = mountPoint;
        this.refresh();
    }

    public void refresh() {
        SigarProxy sigar = SigarAccess.getSigar();
        try {
            if (this.fs == null) {
                this.fs = sigar.getFileSystemMap().getFileSystem(this.mountPoint);
            }
        }
        catch (Exception e) {
            throw new SystemInfoException("Cannot refresh file system mounted at [" + this.mountPoint + "]", e);
        }
        try {
            this.fsUsage = sigar.getMountedFileSystemUsage(this.mountPoint);
        }
        catch (Exception e) {
            this.fsUsage = null;
            this.log.debug((Object)("Cannot refresh the usage data for file system mounted at [" + this.mountPoint + "]"), (Throwable)e);
        }
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public FileSystemUsage getFileSystemUsage() {
        return this.fsUsage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "mountPoint='" + this.mountPoint + '\'' + ", fs=" + this.fs + ", fsUsage=" + this.fsUsage + ']';
    }
}

