/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.util.Comparator;

public class OSGiVersionComparator
implements Comparator<String> {
    @Override
    public int compare(String string1, String string2) {
        Version ver1 = new Version(string1);
        Version ver2 = new Version(string2);
        int result = ver1.major - ver2.major;
        if (result == 0 && (result = ver1.minor - ver2.minor) == 0 && (result = ver1.micro - ver2.micro) == 0) {
            result = ver1.qualifier.compareTo(ver2.qualifier);
        }
        return result;
    }

    private class Version {
        int major;
        int minor;
        int micro;
        String qualifier = "";

        Version(String version) {
            String[] parts = version.split("\\.");
            try {
                switch (parts.length) {
                    case 4: {
                        this.qualifier = parts[3];
                    }
                    case 3: {
                        this.micro = Integer.parseInt(parts[2]);
                    }
                    case 2: {
                        this.minor = Integer.parseInt(parts[1]);
                    }
                    case 1: {
                        this.major = Integer.parseInt(parts[0]);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Malformed version string [" + version + "]");
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Malformed version string [" + version + "]");
            }
        }
    }
}

