/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.parser.filter.ChangeSetFilter;
import liquibase.util.StringUtils;

public class ContextChangeSetFilter
implements ChangeSetFilter {
    private Set<String> contexts = new HashSet<String>();

    public ContextChangeSetFilter(String ... contexts) {
        if (contexts != null) {
            for (int i = 0; i < contexts.length; ++i) {
                if (contexts[i] == null) continue;
                contexts[i] = contexts[i].toLowerCase();
            }
            if (contexts.length == 1) {
                if (contexts[0] != null) {
                    if (contexts[0].indexOf(",") >= 0) {
                        this.contexts.addAll(StringUtils.splitAndTrim(contexts[0], ","));
                    } else {
                        this.contexts.add(contexts[0]);
                    }
                }
            } else {
                this.contexts.addAll(Arrays.asList(contexts));
            }
        }
    }

    public boolean accepts(ChangeSet changeSet) {
        if (this.contexts == null || this.contexts.size() == 0) {
            return true;
        }
        if (changeSet.getContexts() == null) {
            return true;
        }
        for (String context : changeSet.getContexts()) {
            if (!this.contexts.contains(context.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

