/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.DropForeignKeyConstraintStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropForeignKeyConstraintChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private String constraintName;

    public DropForeignKeyConstraintChange() {
        super("dropForeignKeyConstraint", "Drop Foreign Key Constraint");
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.baseTableName) == null) {
            throw new InvalidChangeDefinitionException("baseTableName is required", this);
        }
        if (StringUtils.trimToNull(this.constraintName) == null) {
            throw new InvalidChangeDefinitionException("constraintName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new DropForeignKeyConstraintStatement(this.getBaseTableSchemaName() == null ? database.getDefaultSchemaName() : this.getBaseTableSchemaName(), this.getBaseTableName(), this.getConstraintName())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        return new SqlStatement[0];
    }

    @Override
    public String getConfirmationMessage() {
        return "Foreign key " + this.getConstraintName() + " dropped";
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getBaseTableSchemaName() != null) {
            node.setAttribute("baseTableSchemaName", this.getBaseTableSchemaName());
        }
        node.setAttribute("baseTableName", this.getBaseTableName());
        node.setAttribute("constraintName", this.getConstraintName());
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Table baseTable = new Table(this.getBaseTableName());
        returnSet.add(baseTable);
        ForeignKey fk = new ForeignKey();
        fk.setName(this.constraintName);
        fk.setForeignKeyTable(baseTable);
        returnSet.add(fk);
        return returnSet;
    }
}

