/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import liquibase.database.DatabaseConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLConnectionDelegate
implements DatabaseConnection {
    Connection con;

    public SQLConnectionDelegate(Connection connection) {
        this.con = connection;
    }

    public Connection getWrappedConnection() {
        return this.con;
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.rollback();
        this.con.close();
    }

    @Override
    public void commit() throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.commit();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.con.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.con.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.con.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.con.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.con.prepareStatement(sql);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.rollback();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.con.setTypeMap(map);
    }

    @Override
    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SQLConnectionDelegate)) {
            return false;
        }
        SQLConnectionDelegate otherObj = (SQLConnectionDelegate)obj;
        try {
            return this.getUnderlyingConnection().getMetaData().getURL().equals(otherObj.getUnderlyingConnection().getMetaData().getURL()) && this.getUnderlyingConnection().getMetaData().getUserName().equals(otherObj.getUnderlyingConnection().getMetaData().getUserName());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.getUnderlyingConnection().hashCode();
    }
}

