/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.H2Database;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class AddAutoIncrementStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;

    public AddAutoIncrementStatement(String schemaName, String tableName, String columnName, String columnDataType) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnDataType = columnDataType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof OracleDatabase) && !(database instanceof MSSQLDatabase) && !(database instanceof DerbyDatabase) && !(database instanceof CacheDatabase) && !(database instanceof FirebirdDatabase) && !(database instanceof H2Database) && !(database instanceof PostgresDatabase) && !(database instanceof SQLiteDatabase) && !(database instanceof SybaseASADatabase);
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof HsqlDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " " + this.getColumnDataType() + " GENERATED BY DEFAULT AS IDENTITY IDENTITY";
        }
        if (database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DEFAULT AUTOINCREMENT";
        }
        if (database instanceof DB2Database) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " SET GENERATED ALWAYS AS IDENTITY";
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " " + this.getColumnDataType() + " AUTO_INCREMENT";
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }
}

