/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class AddForeignKeyConstraintStatement
implements SqlStatement {
    private String baseTableSchemaName;
    private String baseTableName;
    private String baseColumnNames;
    private String referencedTableSchemaName;
    private String referencedTableName;
    private String referencedColumnNames;
    private String constraintName;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private Integer deleteRule;
    private Integer updateRule;

    public AddForeignKeyConstraintStatement(String constraintName, String baseTableSchemaName, String baseTableName, String baseColumnNames, String referencedTableSchemaName, String referencedTableName, String referencedColumnNames) {
        this.baseTableSchemaName = baseTableSchemaName;
        this.baseTableName = baseTableName;
        this.baseColumnNames = baseColumnNames;
        this.referencedTableSchemaName = referencedTableSchemaName;
        this.referencedTableName = referencedTableName;
        this.referencedColumnNames = referencedColumnNames;
        this.constraintName = constraintName;
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public String getBaseColumnNames() {
        return this.baseColumnNames;
    }

    public String getReferencedTableSchemaName() {
        return this.referencedTableSchemaName;
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public String getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public AddForeignKeyConstraintStatement setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
        return this;
    }

    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public AddForeignKeyConstraintStatement setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
        return this;
    }

    public AddForeignKeyConstraintStatement setUpdateRule(Integer updateRule) {
        this.updateRule = updateRule;
        return this;
    }

    public AddForeignKeyConstraintStatement setDeleteRule(Integer deleteRule) {
        this.deleteRule = deleteRule;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        String sql = "ALTER TABLE " + database.escapeTableName(this.getBaseTableSchemaName(), this.getBaseTableName()) + " ADD CONSTRAINT " + database.escapeConstraintName(this.getConstraintName()) + " FOREIGN KEY (" + database.escapeColumnNameList(this.getBaseColumnNames()) + ") REFERENCES " + database.escapeTableName(this.getReferencedTableSchemaName(), this.getReferencedTableName()) + "(" + database.escapeColumnNameList(this.getReferencedColumnNames()) + ")";
        if (this.updateRule != null) {
            switch (this.updateRule) {
                case 0: {
                    sql = sql + " ON UPDATE CASCADE";
                    break;
                }
                case 2: {
                    sql = sql + " ON UPDATE SET NULL";
                    break;
                }
                case 4: {
                    sql = sql + " ON UPDATE SET DEFAULT";
                    break;
                }
                case 1: {
                    if (!database.supportsRestrictForeignKeys()) break;
                    sql = sql + " ON UPDATE RESTRICT";
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        if (this.deleteRule != null) {
            switch (this.deleteRule) {
                case 0: {
                    sql = sql + " ON DELETE CASCADE";
                    break;
                }
                case 2: {
                    sql = sql + " ON DELETE SET NULL";
                    break;
                }
                case 4: {
                    sql = sql + " ON DELETE SET DEFAULT";
                    break;
                }
                case 1: {
                    if (!database.supportsRestrictForeignKeys()) break;
                    sql = sql + " ON DELETE RESTRICT";
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        if (this.isDeferrable() || this.isInitiallyDeferred()) {
            if (!database.supportsInitiallyDeferrableColumns()) {
                throw new StatementNotSupportedOnDatabaseException("Database does not support deferrable foreign keys", this, database);
            }
            if (this.isDeferrable()) {
                sql = sql + " DEFERRABLE";
            }
            if (this.isInitiallyDeferred()) {
                sql = sql + " INITIALLY DEFERRED";
            }
        }
        return sql;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

