/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class CreateSequenceStatement
implements SqlStatement {
    private String schemaName;
    private String sequenceName;
    private Integer startValue;
    private Integer incrementBy;
    private Integer maxValue;
    private Integer minValue;
    private Boolean ordered;

    public CreateSequenceStatement(String schemaName, String sequenceName) {
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public Integer getStartValue() {
        return this.startValue;
    }

    public CreateSequenceStatement setStartValue(Integer startValue) {
        this.startValue = startValue;
        return this;
    }

    public Integer getIncrementBy() {
        return this.incrementBy;
    }

    public CreateSequenceStatement setIncrementBy(Integer incrementBy) {
        this.incrementBy = incrementBy;
        return this;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public CreateSequenceStatement setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public CreateSequenceStatement setMinValue(Integer minValue) {
        this.minValue = minValue;
        return this;
    }

    public Boolean getOrdered() {
        return this.ordered;
    }

    public CreateSequenceStatement setOrdered(Boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE SEQUENCE ");
        buffer.append(database.escapeSequenceName(this.getSchemaName(), this.getSequenceName()));
        if (this.getStartValue() != null) {
            if (database instanceof FirebirdDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Firebird does not support creating sequences with startValue", this, database);
            }
            buffer.append(" START WITH ").append(this.getStartValue());
        }
        if (this.getIncrementBy() != null) {
            if (database instanceof FirebirdDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Firebird does not support creating sequences with increments", this, database);
            }
            buffer.append(" INCREMENT BY ").append(this.getIncrementBy());
        }
        if (this.getMinValue() != null) {
            if (database instanceof FirebirdDatabase || database instanceof HsqlDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Database does not support creating sequences with minValue", this, database);
            }
            buffer.append(" MINVALUE ").append(this.getMinValue());
        }
        if (this.getMaxValue() != null) {
            if (database instanceof FirebirdDatabase || database instanceof HsqlDatabase) {
                throw new StatementNotSupportedOnDatabaseException("Database does not support creating sequences with maxValue", this, database);
            }
            buffer.append(" MAXVALUE ").append(this.getMaxValue());
        }
        if (this.getOrdered() != null) {
            if (database instanceof OracleDatabase || database instanceof DB2Database || database instanceof MaxDBDatabase) {
                if (this.getOrdered().booleanValue()) {
                    buffer.append(" ORDER");
                }
            } else {
                throw new StatementNotSupportedOnDatabaseException("Database does not support creating sequences with 'order'", this, database);
            }
        }
        return buffer.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return database.supportsSequences();
    }
}

