/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.ForeignKeyConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UniqueConstraint;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String tablespace;
    private List<String> columns = new ArrayList<String>();
    private Set<String> autoIncrementColumns = new HashSet<String>();
    private Map<String, String> columnTypes = new HashMap<String, String>();
    private Map<String, String> defaultValues = new HashMap<String, String>();
    private PrimaryKeyConstraint primaryKeyConstraint;
    private Set<String> notNullColumns = new HashSet<String>();
    private Set<ForeignKeyConstraint> foreignKeyConstraints = new HashSet<ForeignKeyConstraint>();
    private Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();

    public CreateTableStatement(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public CreateTableStatement setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public Set<ForeignKeyConstraint> getForeignKeyConstraints() {
        return this.foreignKeyConstraints;
    }

    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public Set<String> getNotNullColumns() {
        return this.notNullColumns;
    }

    public CreateTableStatement addPrimaryKeyColumn(String columnName, String columnType, String defaultValue, String keyName, ColumnConstraint ... constraints) {
        PrimaryKeyConstraint pkConstraint = new PrimaryKeyConstraint(keyName);
        pkConstraint.addColumns(columnName);
        ArrayList<ColumnConstraint> allConstraints = new ArrayList<ColumnConstraint>();
        allConstraints.addAll(Arrays.asList(constraints));
        allConstraints.add(new NotNullConstraint(columnName));
        allConstraints.add(pkConstraint);
        this.addColumn(columnName, columnType, defaultValue, allConstraints.toArray(new ColumnConstraint[allConstraints.size()]));
        return this;
    }

    public CreateTableStatement addColumn(String columnName, String columnType) {
        return this.addColumn(columnName, columnType, (String)null, new ColumnConstraint[0]);
    }

    public CreateTableStatement addColumn(String columnName, String columnType, String defaultValue) {
        return this.addColumn(columnName, columnType, defaultValue, new ColumnConstraint[0]);
    }

    public CreateTableStatement addColumn(String columnName, String columnType, ColumnConstraint ... constraints) {
        return this.addColumn(columnName, columnType, (String)null, constraints);
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    public CreateTableStatement addColumn(String columnName, String columnType, String defaultValue, ColumnConstraint ... constraints) {
        this.getColumns().add(columnName);
        this.columnTypes.put(columnName, columnType);
        if (defaultValue != null) {
            this.defaultValues.put(columnName, defaultValue);
        }
        if (constraints != null) {
            for (ColumnConstraint constraint : constraints) {
                if (constraint instanceof PrimaryKeyConstraint) {
                    if (this.getPrimaryKeyConstraint() == null) {
                        this.primaryKeyConstraint = (PrimaryKeyConstraint)constraint;
                        continue;
                    }
                    for (String column : ((PrimaryKeyConstraint)constraint).getColumns()) {
                        this.getPrimaryKeyConstraint().addColumns(column);
                    }
                    continue;
                }
                if (constraint instanceof NotNullConstraint) {
                    ((NotNullConstraint)constraint).setColumnName(columnName);
                    this.getNotNullColumns().add(columnName);
                    continue;
                }
                if (constraint instanceof ForeignKeyConstraint) {
                    ((ForeignKeyConstraint)constraint).setColumn(columnName);
                    this.getForeignKeyConstraints().add((ForeignKeyConstraint)constraint);
                    continue;
                }
                if (constraint instanceof UniqueConstraint) {
                    ((UniqueConstraint)constraint).addColumns(columnName);
                    this.getUniqueConstraints().add((UniqueConstraint)constraint);
                    continue;
                }
                if (constraint instanceof AutoIncrementConstraint) {
                    this.autoIncrementColumns.add(columnName);
                    continue;
                }
                throw new RuntimeException("Unknown constraint type: " + constraint.getClass().getName());
            }
        }
        return this;
    }

    @Override
    public String getSqlStatement(Database database) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE TABLE ").append(database.escapeTableName(this.getSchemaName(), this.getTableName())).append(" ");
        buffer.append("(");
        Iterator<String> columnIterator = this.getColumns().iterator();
        while (columnIterator.hasNext()) {
            String column = columnIterator.next();
            boolean isAutoIncrement = this.autoIncrementColumns.contains(column);
            buffer.append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), column));
            buffer.append(" ").append(database.getColumnType(this.columnTypes.get(column), isAutoIncrement));
            if (database instanceof SQLiteDatabase && this.getPrimaryKeyConstraint() != null && this.getPrimaryKeyConstraint().getColumns().size() == 1 && this.getPrimaryKeyConstraint().getColumns().contains(column) && isAutoIncrement) {
                String pkName = StringUtils.trimToNull(this.getPrimaryKeyConstraint().getConstraintName());
                if (pkName == null) {
                    pkName = database.generatePrimaryKeyName(this.getTableName());
                }
                buffer.append(" CONSTRAINT ");
                buffer.append(database.escapeConstraintName(pkName));
                buffer.append(" PRIMARY KEY AUTOINCREMENT");
            }
            if (this.getDefaultValue(column) != null) {
                if (database instanceof MSSQLDatabase) {
                    buffer.append(" CONSTRAINT ").append(((MSSQLDatabase)database).generateDefaultConstraintName(this.tableName, column));
                }
                buffer.append(" DEFAULT ");
                buffer.append(this.getDefaultValue(column));
            }
            if (isAutoIncrement && database.getAutoIncrementClause() != null && !database.getAutoIncrementClause().equals("")) {
                if (database.supportsAutoIncrement()) {
                    buffer.append(" ").append(database.getAutoIncrementClause()).append(" ");
                } else {
                    LogFactory.getLogger().log(Level.WARNING, database.getProductName() + " does not support autoincrement columns as request for " + database.escapeTableName(this.getSchemaName(), this.getTableName()));
                }
            }
            if (this.getNotNullColumns().contains(column)) {
                buffer.append(" NOT NULL");
            } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
                buffer.append(" NULL");
            }
            if (!columnIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(",");
        if (!(database instanceof SQLiteDatabase && this.getPrimaryKeyConstraint() != null && this.getPrimaryKeyConstraint().getColumns().size() == 1 && this.autoIncrementColumns.contains(this.getPrimaryKeyConstraint().getColumns().get(0)) || this.getPrimaryKeyConstraint() == null || this.getPrimaryKeyConstraint().getColumns().size() <= 0)) {
            String pkName = StringUtils.trimToNull(this.getPrimaryKeyConstraint().getConstraintName());
            if (pkName == null) {
                pkName = database.generatePrimaryKeyName(this.getTableName());
            }
            buffer.append(" CONSTRAINT ");
            buffer.append(database.escapeConstraintName(pkName));
            buffer.append(" PRIMARY KEY (");
            buffer.append(database.escapeColumnNameList(StringUtils.join(this.getPrimaryKeyConstraint().getColumns(), ", ")));
            buffer.append(")");
            buffer.append(",");
        }
        for (ForeignKeyConstraint fkConstraint : this.getForeignKeyConstraints()) {
            buffer.append(" CONSTRAINT ").append(database.escapeConstraintName(fkConstraint.getForeignKeyName())).append(" FOREIGN KEY (").append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), fkConstraint.getColumn())).append(") REFERENCES ").append(fkConstraint.getReferences());
            if (fkConstraint.isDeleteCascade()) {
                buffer.append(" ON DELETE CASCADE");
            }
            if (fkConstraint.isInitiallyDeferred()) {
                buffer.append(" INITIALLY DEFERRED");
            }
            if (fkConstraint.isDeferrable()) {
                buffer.append(" DEFERRABLE");
            }
            buffer.append(",");
        }
        for (UniqueConstraint uniqueConstraint : this.getUniqueConstraints()) {
            if (uniqueConstraint.getConstraintName() != null) {
                buffer.append(" CONSTRAINT ");
                buffer.append(database.escapeConstraintName(uniqueConstraint.getConstraintName()));
            }
            buffer.append(" UNIQUE (");
            buffer.append(database.escapeColumnNameList(StringUtils.join(uniqueConstraint.getColumns(), ", ")));
            buffer.append("),");
        }
        String sql = buffer.toString().replaceFirst(",\\s*$", "") + ")";
        if (this.getTablespace() != null && database.supportsTablespaces()) {
            sql = database instanceof MSSQLDatabase || database instanceof SybaseASADatabase ? sql + " ON " + this.getTablespace() : (database instanceof DB2Database ? sql + " IN " + this.getTablespace() : sql + " TABLESPACE " + this.getTablespace());
        }
        return sql;
    }

    public String getDefaultValue(String column) {
        return this.defaultValues.get(column);
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    public CreateTableStatement addColumnConstraint(NotNullConstraint notNullConstraint) {
        this.getNotNullColumns().add(notNullConstraint.getColumnName());
        return this;
    }

    public CreateTableStatement addColumnConstraint(ForeignKeyConstraint fkConstraint) {
        this.getForeignKeyConstraints().add(fkConstraint);
        return this;
    }

    public CreateTableStatement addColumnConstraint(UniqueConstraint uniqueConstraint) {
        this.getUniqueConstraints().add(uniqueConstraint);
        return this;
    }

    public CreateTableStatement addColumnConstraint(AutoIncrementConstraint autoIncrementConstraint) {
        this.autoIncrementColumns.add(autoIncrementConstraint.getColumnName());
        return this;
    }
}

