/*
 * Decompiled with CFR 0.152.
 */
package liquibase.spring;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import liquibase.FileOpener;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.JDBCException;
import liquibase.exception.LiquibaseException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    private String beanName;
    private ResourceLoader resourceLoader;
    private DataSource dataSource;
    private Logger log = Logger.getLogger(SpringLiquibase.class.getName());
    private String changeLog;
    private String contexts;

    public String getDatabaseProductName() throws JDBCException {
        Connection connection = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(this.dataSource.getConnection());
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "problem closing connection", e);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            System.out.println("LiquiBase did not run because 'liquibase.should.run' system property was set to false");
            return;
        }
        Connection c = null;
        try {
            c = this.getDataSource().getConnection();
            Liquibase liquibase = this.createLiquibase(c);
            liquibase.update(this.getContexts());
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private Liquibase createLiquibase(Connection c) throws JDBCException {
        return new Liquibase(this.getChangeLog(), (FileOpener)new SpringResourceOpener(this.getChangeLog()), DatabaseFactory.getInstance().findCorrectDatabaseImplementation(c));
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpringResourceOpener
    implements FileOpener {
        private String parentFile;

        public SpringResourceOpener(String parentFile) {
            this.parentFile = parentFile;
        }

        @Override
        public InputStream getResourceAsStream(String file) throws IOException {
            Resource resource = this.getResource(file);
            return resource.getInputStream();
        }

        @Override
        public Enumeration<URL> getResources(String packageName) throws IOException {
            Vector<URL> tmp = new Vector<URL>();
            tmp.add(this.getResource(packageName).getURL());
            return tmp.elements();
        }

        public Resource getResource(String file) {
            return SpringLiquibase.this.getResourceLoader().getResource(this.adjustClasspath(file));
        }

        private String adjustClasspath(String file) {
            return this.isClasspathPrefixPresent(this.parentFile) && !this.isClasspathPrefixPresent(file) ? "classpath:" + file : file;
        }

        public boolean isClasspathPrefixPresent(String file) {
            return file.startsWith("classpath:");
        }

        @Override
        public ClassLoader toClassLoader() {
            return SpringLiquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

