/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.InputStream;
import java.util.Map;

public class HandoverInfo {
    private final InputStream content;
    private final String filename;
    private final String action;
    private final Map<String, String> params;
    private final boolean revert;

    private HandoverInfo(InputStream content, String filename, String action, Map<String, String> params, boolean revert) {
        this.content = content;
        this.filename = filename;
        this.action = action;
        this.params = params;
        this.revert = revert;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getAction() {
        return this.action;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean isRevert() {
        return this.revert;
    }

    public String toString() {
        return "HandoverInfo[content=" + this.content + ", filename='" + this.filename + '\'' + ", action='" + this.action + '\'' + ", params=" + this.params + ']';
    }

    public static class Builder {
        private InputStream content;
        private String filename;
        private String action;
        private Map<String, String> params;
        private boolean revert;

        public Builder setContent(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder setRevert(boolean revert) {
            this.revert = revert;
            return this;
        }

        public HandoverInfo createHandoverInfo() {
            return new HandoverInfo(this.content, this.filename, this.action, this.params, this.revert);
        }
    }
}

