/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.File;
import java.io.IOException;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.file.ContentFileInfo;

public class GenericContentFileInfo
extends ContentFileInfo {
    public GenericContentFileInfo(File file) {
        super(file);
    }

    @Override
    public boolean isValid() {
        return this.getContentFile().exists() && this.getContentFile().canRead();
    }

    @Override
    public String getVersion(String defaultValue) {
        if (defaultValue != null) {
            return defaultValue;
        }
        try {
            return MessageDigestGenerator.getDigestString(this.getContentFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot generate version for file [" + this.getContentFile() + "]", e);
        }
    }

    @Override
    public String getDescription(String defaultValue) {
        return defaultValue;
    }
}

