/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system.pquery;

import org.rhq.core.system.pquery.Attribute;

class Conditional {
    char separator = (char)124;
    private Category category;
    private Attribute attribute;
    private Operator operator;
    private Qualifier qualifier;

    Conditional(String conditional) {
        String[] tokens;
        char possibleSeparator = conditional.charAt(0);
        if (!Character.isLetter(possibleSeparator)) {
            this.separator = possibleSeparator;
            conditional = conditional.substring(1);
        }
        if ((tokens = conditional.split("\\" + this.separator, 4)).length < 3 || tokens.length > 4) {
            throw new IllegalArgumentException("Conditional needs a category, attribute and operator: " + conditional);
        }
        String categoryString = tokens[0];
        String attributeString = tokens[1];
        String operatorString = tokens[2];
        String qualifierString = tokens.length == 4 ? tokens[3] : null;
        try {
            this.category = Category.valueOf(categoryString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.category == null) {
            throw new IllegalArgumentException("Invalid category: " + conditional);
        }
        this.attribute = new Attribute(attributeString, this.category);
        try {
            this.operator = Operator.valueOf(operatorString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.operator == null) {
            throw new IllegalArgumentException("Invalid operator: " + conditional);
        }
        if (qualifierString != null) {
            try {
                this.qualifier = Qualifier.valueOf(qualifierString);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.qualifier == null) {
                throw new IllegalArgumentException("Invalid qualifier: " + conditional);
            }
        } else {
            this.qualifier = Qualifier.unspecified;
        }
    }

    Category getCategory() {
        return this.category;
    }

    Attribute getAttribute() {
        return this.attribute;
    }

    Operator getOperator() {
        return this.operator;
    }

    Qualifier getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        String str = "" + (Object)((Object)this.category) + this.separator + this.attribute + this.separator + (Object)((Object)this.operator);
        if (this.qualifier != null) {
            str = str + "" + this.separator + (Object)((Object)this.qualifier);
        }
        return str;
    }

    static enum Qualifier {
        unspecified,
        parent;

    }

    static enum Operator {
        match,
        nomatch;

    }

    static enum Category {
        process,
        arg;

    }
}

