/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtil {
    private static final Log log = LogFactory.getLog(StringUtil.class);

    public static String replace(String source, String find, String replace) {
        int idx;
        if (source == null || find == null || replace == null) {
            return source;
        }
        int sourceLen = source.length();
        int findLen = find.length();
        if (sourceLen == 0 || findLen == 0) {
            return source;
        }
        StringBuilder buffer = new StringBuilder();
        int fromIndex = 0;
        while ((idx = source.indexOf(find, fromIndex)) != -1) {
            buffer.append(source.substring(fromIndex, idx));
            buffer.append(replace);
            fromIndex = idx + findLen;
        }
        if (fromIndex == 0) {
            return source;
        }
        buffer.append(source.substring(fromIndex));
        return buffer.toString();
    }

    public static String remove(String source, String find) {
        if (source == null || find == null) {
            return source;
        }
        String retVal = null;
        int sourceLen = source.length();
        int findLen = find.length();
        StringBuilder remove = new StringBuilder(source);
        try {
            if (sourceLen > 0 && findLen > 0) {
                int fromIndex = 0;
                int idx = 0;
                while ((fromIndex = source.indexOf(find, idx)) != -1) {
                    remove.delete(fromIndex, findLen + fromIndex);
                    idx = fromIndex + findLen;
                }
                retVal = remove.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)"This should not have happened.", (Throwable)e);
            retVal = null;
        }
        return retVal;
    }

    public static String iteratorToString(Iterator i, String delim) {
        return StringUtil.iteratorToString(i, delim, "");
    }

    public static String iteratorToString(Iterator i, String delim, String quoteChar) {
        Object elt = null;
        StringBuilder rstr = new StringBuilder();
        while (i.hasNext()) {
            if (rstr.length() > 0) {
                rstr.append(delim);
            }
            if ((elt = (Object)i.next()) == null) {
                rstr.append("NULL");
                continue;
            }
            String s = elt.toString();
            if (quoteChar != null) {
                rstr.append(quoteChar).append(s).append(quoteChar);
                continue;
            }
            rstr.append(s);
        }
        return rstr.toString();
    }

    public static String listToString(List list, String delim) {
        if (list == null) {
            return "NULL";
        }
        Iterator i = list.iterator();
        return StringUtil.iteratorToString(i, delim, null);
    }

    public static String collectionToString(Collection collection, String delim) {
        if (collection == null) {
            return "NULL";
        }
        Iterator i = collection.iterator();
        return StringUtil.iteratorToString(i, delim, null);
    }

    public static String listToString(List list) {
        return StringUtil.listToString(list, ",");
    }

    public static String collectionToString(Collection collection) {
        return StringUtil.collectionToString(collection, ",");
    }

    public static String arrayToString(Object[] array) {
        return StringUtil.arrayToString(array, ',');
    }

    public static String arrayToString(boolean[] array) {
        if (array == null) {
            return "null";
        }
        String rstr = "";
        char delim = ',';
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                rstr = rstr + delim;
            }
            rstr = rstr + array[i];
        }
        return rstr;
    }

    public static String arrayToString(Object[] array, char delim) {
        if (array == null) {
            return "null";
        }
        StringBuilder rstr = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                rstr.append(delim);
            }
            rstr.append(array[i]);
        }
        return rstr.toString();
    }

    public static String arrayToString(int[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder rstr = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                rstr.append(",");
            }
            rstr.append(array[i]);
        }
        return rstr.toString();
    }

    public static String implode(List objs, String delim) {
        StringBuilder buf = new StringBuilder();
        int size = objs.size();
        for (int i = 0; i < size - 1; ++i) {
            buf.append(objs.get(i).toString());
            buf.append(delim);
        }
        if (size != 0) {
            buf.append(objs.get(size - 1).toString());
        }
        return buf.toString();
    }

    public static List<String> explode(String s, String delim) {
        ArrayList<String> res = new ArrayList<String>();
        if (s == null) {
            return res;
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        while (tok.hasMoreTokens()) {
            res.add(tok.nextToken());
        }
        return res;
    }

    public static String[] explodeToArray(String toExplode, String delim) {
        List<String> strings = StringUtil.explode(toExplode, delim);
        String[] ret = strings.toArray(new String[strings.size()]);
        return ret;
    }

    public static String[] explodeQuoted(String arg) throws IllegalArgumentException {
        ArrayList<String> res = new ArrayList<String>();
        boolean inQuote = false;
        arg = arg.trim();
        StringTokenizer quoteTok = new StringTokenizer(arg, "\"", true);
        while (quoteTok.hasMoreTokens()) {
            String elem = (String)quoteTok.nextElement();
            if (elem.equals("\"")) {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                res.add(elem);
                continue;
            }
            StringTokenizer spaceTok = new StringTokenizer(elem.trim());
            while (spaceTok.hasMoreTokens()) {
                res.add(spaceTok.nextToken());
            }
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unbalanced quotation marks");
        }
        return res.toArray(new String[res.size()]);
    }

    public static String removePrefix(String value, String prefix) {
        if (!value.startsWith(prefix)) {
            return value;
        }
        return value.substring(prefix.length()).trim();
    }

    public static String pluralize(String word) {
        if (word.endsWith("s") || word.endsWith("x") || word.endsWith("o") || word.endsWith("ch")) {
            return word + "es";
        }
        if (word.endsWith("y")) {
            if (word.length() == 1) {
                return word;
            }
            char next2last = word.charAt(word.length() - 2);
            if (next2last != 'a' && next2last != 'e' && next2last != 'i' && next2last != 'o' && next2last != 'u' && next2last != 'y') {
                return word.substring(0, word.length() - 1) + "ies";
            }
        }
        return word + "s";
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "THROWABLE-WAS-NULL (at " + StringUtil.getStackTrace(new Exception()) + ")";
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            Throwable cause = t.getCause();
            if (cause != null) {
                return sw.toString() + StringUtil.getStackTrace(cause);
            }
            return sw.toString();
        }
        catch (Exception e) {
            return "\n\nStringUtil.getStackTrace GENERATED EXCEPTION: '" + e.toString() + "' \n\n";
        }
    }

    public static String getFirstStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String normalizePath(String s) {
        return StringUtil.replace(s, "/", File.separator);
    }

    public static String formatDuration(long duration) {
        return StringUtil.formatDuration(duration, 0, false);
    }

    public static String formatDuration(long duration, int scale, boolean minDigits) {
        long hours = duration / 3600000L;
        long mins = (duration -= hours * 3600000L) / 60000L;
        double millis = (double)(duration -= mins * 60000L) / 1000.0;
        StringBuilder buf = new StringBuilder();
        if (hours > 0L || !minDigits) {
            buf.append(hours < 10L && !minDigits ? "0" + hours : String.valueOf(hours)).append(':');
            minDigits = false;
        }
        if (mins > 0L || !minDigits) {
            buf.append(mins < 10L && !minDigits ? "0" + mins : String.valueOf(mins)).append(':');
            minDigits = false;
        }
        NumberFormat fmt = NumberFormat.getInstance();
        int digits = !minDigits || scale == 0 && millis >= 9.5 ? 2 : 1;
        fmt.setMinimumIntegerDigits(digits);
        fmt.setMaximumIntegerDigits(2);
        fmt.setMinimumFractionDigits(0);
        fmt.setMaximumFractionDigits(scale);
        buf.append(fmt.format(millis));
        return buf.toString();
    }

    public static String repeatChars(char c, int nTimes) {
        char[] arr = new char[nTimes];
        for (int i = 0; i < nTimes; ++i) {
            arr[i] = c;
        }
        return new String(arr);
    }

    public static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().equals("")) {
            return str;
        }
        String result = str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
        return result;
    }

    public static String truncate(String s, int truncLength, boolean removeWhiteSpace) {
        String temp;
        String string = temp = s.length() > truncLength ? s.substring(0, truncLength) + "..." : s;
        if (removeWhiteSpace) {
            temp = temp.replaceAll("\\s+", " ");
        }
        return temp;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

