/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.stream.StreamCopyDigest;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.FileHashcodeMap;

public class ExtractorZipFileVisitor
implements ZipUtil.ZipEntryVisitor {
    private final FileHashcodeMap fileHashcodeMap = new FileHashcodeMap();
    private final Pattern filesToRealizeRegex;
    private final TemplateEngine templateEngine;
    private final File rootDir;
    private final Set<String> filesToNotExtract;
    private final StreamCopyDigest copierAndHashcodeGenerator;
    private final DeployDifferences diff;
    private final boolean dryRun;

    public ExtractorZipFileVisitor(File rootDir, Pattern filesToRealizeRegex, TemplateEngine templateEngine, Set<String> filesToNotExtract, DeployDifferences diff, boolean dryRun) {
        this.rootDir = rootDir;
        if (filesToRealizeRegex == null || templateEngine == null) {
            filesToRealizeRegex = null;
            templateEngine = null;
        }
        this.filesToRealizeRegex = filesToRealizeRegex;
        this.templateEngine = templateEngine;
        if (filesToNotExtract != null && filesToNotExtract.size() == 0) {
            filesToNotExtract = null;
        }
        this.filesToNotExtract = filesToNotExtract;
        this.copierAndHashcodeGenerator = new StreamCopyDigest();
        this.diff = diff;
        this.dryRun = dryRun;
    }

    public FileHashcodeMap getFileHashcodeMap() {
        return this.fileHashcodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
        String hashcode;
        String pathname = entry.getName();
        if (this.filesToNotExtract != null && this.filesToNotExtract.contains(pathname)) {
            return true;
        }
        File entryFile = new File(this.rootDir, pathname);
        if (entry.isDirectory()) {
            if (!this.dryRun) {
                entryFile.mkdirs();
            }
            return true;
        }
        if (!this.dryRun) {
            entryFile.getParentFile().mkdirs();
        }
        if (this.filesToRealizeRegex != null && this.filesToRealizeRegex.matcher(pathname).matches()) {
            int contentSize = (int)entry.getSize();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(contentSize > 0 ? contentSize : 32768);
            StreamUtil.copy(stream, baos, false);
            String content = this.templateEngine.replaceTokens(baos.toString());
            baos = null;
            if (this.diff != null) {
                this.diff.addRealizedFile(pathname, content);
            }
            byte[] bytes = content.getBytes();
            if (!this.dryRun) {
                FileOutputStream fos = new FileOutputStream(entryFile);
                try {
                    fos.write(bytes);
                }
                finally {
                    fos.close();
                }
            }
            MessageDigestGenerator hashcodeGenerator = this.copierAndHashcodeGenerator.getMessageDigestGenerator();
            hashcodeGenerator.add(bytes);
            hashcode = hashcodeGenerator.getDigestString();
        } else if (!this.dryRun) {
            FileOutputStream fos = new FileOutputStream(entryFile);
            try {
                hashcode = this.copierAndHashcodeGenerator.copyAndCalculateHashcode(stream, fos);
            }
            finally {
                fos.close();
            }
        } else {
            hashcode = MessageDigestGenerator.getDigestString(stream);
        }
        this.fileHashcodeMap.put(pathname, hashcode);
        return true;
    }
}

