/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;

public class DeleteStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String whereClause;
    private List<Object> whereParameters = new ArrayList<Object>();

    public DeleteStatement(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public DeleteStatement setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public void addWhereParameter(Object value) {
        this.whereParameters.add(value);
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }

    public String getSqlStatement(Database database) {
        StringBuffer sql = new StringBuffer("DELETE FROM " + database.escapeTableName(this.getSchemaName(), this.getTableName()));
        if (this.whereClause != null) {
            String fixedWhereClause = " WHERE " + this.whereClause;
            for (Object param : this.whereParameters) {
                fixedWhereClause = fixedWhereClause.replaceFirst("\\?", this.convertToString(param, database));
            }
            sql.append(" ").append(fixedWhereClause);
        }
        return sql.toString();
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString = newValue == null ? "NULL" : (newValue instanceof String && database.shouldQuoteValue((String)newValue) ? "'" + newValue + "'" : (newValue instanceof Date ? database.getDateLiteral((Date)newValue) : (newValue instanceof Boolean ? (((Boolean)newValue).booleanValue() ? database.getTrueBooleanValue() : database.getFalseBooleanValue()) : newValue.toString())));
        return sqlString;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }
}

