/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.statement.core.RawSqlStatement;

public class MySQLDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "MySQL";

    public String getTypeName() {
        return "mysql";
    }

    public int getPriority() {
        return 1;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:mysql")) {
            return "com.mysql.jdbc.Driver";
        }
        return null;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "NOW()";
    }

    public String getLineComment() {
        return "--";
    }

    protected String getAutoIncrementClause() {
        return "AUTO_INCREMENT";
    }

    protected boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return false;
    }

    protected String getAutoIncrementOpening() {
        return "";
    }

    protected String getAutoIncrementClosing() {
        return "";
    }

    protected String getAutoIncrementStartWithClause() {
        return "=%d";
    }

    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        returnString.append("CONCAT_WS(");
        for (String value : values) {
            returnString.append(value).append(", ");
        }
        return returnString.toString().replaceFirst(", $", ")");
    }

    public boolean supportsTablespaces() {
        return false;
    }

    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return this.getConnection().getCatalog();
    }

    public String convertRequestedSchemaToSchema(String requestedSchema) throws DatabaseException {
        if (requestedSchema == null) {
            return this.getDefaultDatabaseSchemaName();
        }
        return requestedSchema;
    }

    public String convertRequestedSchemaToCatalog(String requestedSchema) throws DatabaseException {
        return requestedSchema;
    }

    public String escapeDatabaseObject(String objectName) {
        return "`" + objectName + "`";
    }

    public String escapeIndexName(String schemaName, String indexName) {
        return this.escapeDatabaseObject(indexName);
    }

    public boolean supportsForeignKeyDisable() {
        return true;
    }

    public boolean disableForeignKeyChecks() throws DatabaseException {
        boolean enabled = ExecutorService.getInstance().getExecutor(this).queryForInt(new RawSqlStatement("SELECT @@FOREIGN_KEY_CHECKS")) == 1;
        ExecutorService.getInstance().getExecutor(this).execute(new RawSqlStatement("SET FOREIGN_KEY_CHECKS=0"));
        return enabled;
    }

    public void enableForeignKeyChecks() throws DatabaseException {
        ExecutorService.getInstance().getExecutor(this).execute(new RawSqlStatement("SET FOREIGN_KEY_CHECKS=1"));
    }
}

