/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;
import org.rhq.plugins.www.util.WWWUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheVirtualHostServiceComponent
implements ResourceComponent<ApacheServerComponent>,
MeasurementFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String SNMP_WWW_SERVICE_INDEX_CONFIG_PROP = "snmpWwwServiceIndex";
    public static final String URL_CONFIG_PROP = "url";
    public static final String RESPONSE_TIME_LOG_FILE_CONFIG_PROP = "responseTimeLogFile";
    public static final String RESPONSE_TIME_URL_EXCLUDES_CONFIG_PROP = "responseTimeUrlExcludes";
    public static final String RESPONSE_TIME_URL_TRANSFORMS_CONFIG_PROP = "responseTimeUrlTransforms";
    private static final String RESPONSE_TIME_METRIC = "ResponseTime";
    private static final double RESPONSE_TIME_LOG_TIME_MULTIPLIER = 0.001;
    private ResourceContext<ApacheServerComponent> resourceContext;
    private URL url;
    private ResponseTimeLogParser logParser;

    public void start(ResourceContext<ApacheServerComponent> resourceContext) throws Exception {
        this.resourceContext = resourceContext;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String url = pluginConfig.getSimple(URL_CONFIG_PROP).getStringValue();
        try {
            this.url = new URL(url);
            if (this.url.getPort() == 0) {
                throw new InvalidPluginConfigurationException("The 'url' connection property is invalid - 0 is not a valid port; please change the value to the port this virtual host is listening on. NOTE: If the 'url' property was set this way after autodiscovery, you most likely did not include the port in the ServerName directive for this virtual host in httpd.conf.");
            }
        }
        catch (MalformedURLException e) {
            throw new Exception("Value of 'url' connection property ('" + url + "') is not a valid URL.");
        }
        ResponseTimeConfiguration responseTimeConfig = new ResponseTimeConfiguration(pluginConfig);
        File logFile = responseTimeConfig.getLogFile();
        if (logFile != null) {
            this.logParser = new ResponseTimeLogParser(logFile, 0.001);
            this.logParser.setExcludes(responseTimeConfig.getExcludes());
            this.logParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    public void stop() {
        this.resourceContext = null;
        this.url = null;
    }

    public AvailabilityType getAvailability() {
        return WWWUtils.isAvailable(this.url) ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) throws Exception {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        int primaryIndex = pluginConfig.getSimple(SNMP_WWW_SERVICE_INDEX_CONFIG_PROP).getIntegerValue();
        this.log.debug((Object)("Collecting metrics for VirtualHost service #" + primaryIndex + "..."));
        SNMPSession snmpSession = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getSNMPSession();
        if (!snmpSession.ping()) {
            this.log.debug((Object)("Failed to connect to SNMP agent at " + snmpSession + " - aborting metric collection..."));
            return;
        }
        for (MeasurementScheduleRequest schedule : schedules) {
            String metricName = schedule.getName();
            if (metricName.equals(RESPONSE_TIME_METRIC)) {
                if (this.logParser != null) {
                    try {
                        CallTimeData callTimeData = new CallTimeData(schedule);
                        this.logParser.parseLog(callTimeData);
                        report.addData(callTimeData);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to retrieve HTTP call-time data.", (Throwable)e);
                    }
                    continue;
                }
                this.log.error((Object)("The 'ResponseTime' metric is enabled for resource '" + this.resourceContext.getResourceKey() + "', but no value is defined for the '" + RESPONSE_TIME_LOG_FILE_CONFIG_PROP + "' connection property."));
                continue;
            }
            try {
                this.collectSnmpMetric(report, primaryIndex, snmpSession, schedule);
            }
            catch (SNMPException e) {
                this.log.error((Object)"An error occurred while attempting to collect an SNMP metric.", (Throwable)e);
            }
        }
        this.log.info((Object)("Collected " + report.getDataCount() + " metrics for VirtualHost " + this.resourceContext.getResourceKey() + "."));
    }

    private void collectSnmpMetric(MeasurementReport report, int primaryIndex, SNMPSession snmpSession, MeasurementScheduleRequest schedule) throws SNMPException {
        SNMPValue snmpValue = null;
        String metricName = schedule.getName();
        int dotIndex = metricName.indexOf(46);
        if (dotIndex == -1) {
            String mibName = metricName;
            List<SNMPValue> snmpValues = snmpSession.getColumn(mibName);
            snmpValue = snmpValues.get(primaryIndex - 1);
        } else {
            String oid;
            String mibName = metricName.substring(0, dotIndex);
            String mibSecondaryIndex = metricName.substring(dotIndex + 1);
            try {
                Integer.parseInt(mibSecondaryIndex);
                oid = mibSecondaryIndex;
            }
            catch (NumberFormatException e) {
                oid = this.convertStringToOid(mibSecondaryIndex);
            }
            boolean found = false;
            Map<String, SNMPValue> table = snmpSession.getTable(mibName, primaryIndex);
            if (table != null && (snmpValue = table.get(oid)) != null) {
                found = true;
            }
            if (!found) {
                this.log.error((Object)("Entry '" + oid + "' not found for " + mibName + "[" + primaryIndex + "]."));
                this.log.error((Object)("Table:\n" + table));
                return;
            }
        }
        this.log.debug((Object)("Collected SNMP metric [" + metricName + "], value = " + snmpValue));
        boolean valueIsTimestamp = false;
        ApacheServerComponent.addSnmpMetricValueToReport(report, schedule, snmpValue, valueIsTimestamp);
    }

    private String convertStringToOid(String string) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(string.length());
        for (int i = 0; i < string.length(); ++i) {
            strBuf.append('.').append((byte)string.charAt(i));
        }
        String oid = strBuf.toString();
        return oid;
    }
}

