/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheIfModuleComponent
implements ResourceComponent<ApacheVirtualHostServiceComponent>,
ConfigurationFacet,
DeleteResourceFacet {
    private AugeasTree tree;
    private ResourceContext<ApacheVirtualHostServiceComponent> context;
    private ApacheVirtualHostServiceComponent parentComponent;
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String IFMODULE_DIRECTIVE_NAME = "<IfModule";

    public void start(ResourceContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        this.parentComponent = (ApacheVirtualHostServiceComponent)context.getParentResourceComponent();
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.parentComponent.getAvailability();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        AugeasTree tree = this.parentComponent.getServerConfigurationTree();
        ConfigurationDefinition resourceConfigDef = this.context.getResourceType().getResourceConfigurationDefinition();
        AugeasNode virtualHostNode = this.parentComponent.getNode(tree);
        ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
        return mapping.updateConfiguration(this.getNode(virtualHostNode), resourceConfigDef);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        AugeasTree tree = null;
        try {
            tree = this.parentComponent.getServerConfigurationTree();
            ConfigurationDefinition resourceConfigDef = this.context.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode directoryNode = this.getNode(this.parentComponent.getNode(tree));
            mapping.updateAugeas(directoryNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            this.log.info((Object)"Apache configuration was updated");
            ((ApacheVirtualHostServiceComponent)this.context.getParentResourceComponent()).finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                this.log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()));
            } else {
                this.log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public void deleteResource() throws Exception {
    }

    private AugeasNode getNode(AugeasNode virtualHost) {
        AugeasNode directory = AugeasNodeSearch.findNodeById(virtualHost, this.context.getResourceKey());
        return directory;
    }

    private void prepareNode(AugeasNode node, AugeasNode parentNode, AugeasTree tree, Configuration configuration) {
        List<String> params = AugeasNodeSearch.getParams(node, parentNode);
        PropertyList list = (PropertyList)configuration.get("IfModules");
        ArrayList<String> newParams = new ArrayList<String>();
        for (Property prop : list.getList()) {
            if (!(prop instanceof PropertyMap)) continue;
            PropertyMap propMap = (PropertyMap)prop;
            PropertySimple value = (PropertySimple)propMap.get("condition");
            newParams.add(value.getStringValue());
        }
        int i = 0;
        int position = 0;
        AugeasNode tempNode = parentNode;
        boolean updated = true;
        block1: while (updated) {
            updated = false;
            List nodes = tempNode.getChildByLabel(IFMODULE_DIRECTIVE_NAME);
            for (AugeasNode nd : nodes) {
                String value;
                List paramNodes = nd.getChildByLabel("param");
                if (paramNodes.size() <= 0 || !(value = ((AugeasNode)paramNodes.get(0)).getValue()).equals(newParams.get(position))) continue;
                ++position;
                tempNode = nd;
                updated = true;
                continue block1;
            }
        }
        for (i = position; i < newParams.size(); ++i) {
            int size = tempNode.getChildByLabel(IFMODULE_DIRECTIVE_NAME).size() + 1;
            tempNode = tree.createNode(tempNode, IFMODULE_DIRECTIVE_NAME, null, size);
            tree.createNode(tempNode, "param", (String)newParams.get(i), 1);
        }
    }

    public void copy(AugeasNode a, AugeasNode b) {
        for (AugeasNode nd : a.getChildNodes()) {
            AugeasNode tempNode = this.tree.createNode(b, nd.getLabel(), nd.getValue(), nd.getSeq());
            this.copy(nd, tempNode);
        }
    }
}

