/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.augeas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.rhqtransform.AugeasRhqException;
import org.rhq.rhqtransform.impl.PluginDescriptorBasedAugeasConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugeasConfigurationApache
extends PluginDescriptorBasedAugeasConfiguration {
    public static final String INCLUDE_DIRECTIVE = "Include";
    private static final String INCLUDE_FILES_PATTERN = "^[\t ]*Include[\t ]+(.*)$";
    private static final String SERVER_ROOT_PATTERN = "^[\t ]*ServerRoot[\t ]+[\"]?([^\"\n]*)[\"]?$";
    private final Pattern includePattern = Pattern.compile("^[\t ]*Include[\t ]+(.*)$");
    private final Pattern serverRootPattern = Pattern.compile("^[\t ]*ServerRoot[\t ]+[\"]?([^\"\n]*)[\"]?$");
    private String serverRootPath;
    private AugeasModuleConfig module;
    private List<File> allConfigFiles;

    public String getServerRootPath() {
        return this.serverRootPath;
    }

    public AugeasConfigurationApache(Configuration configuration) throws AugeasRhqException {
        super(configuration);
        this.serverRootPath = configuration.getSimpleValue("serverRoot", null);
        if (this.modules.isEmpty()) {
            throw new AugeasRhqException("There is not configuration for this resource.");
        }
        try {
            this.module = (AugeasModuleConfig)this.modules.get(0);
            ArrayList<String> foundIncludes = new ArrayList<String>();
            this.loadIncludes((String)this.module.getIncludedGlobs().get(0), foundIncludes);
            this.allConfigFiles = AugeasConfigurationApache.getIncludeFiles(this.serverRootPath, foundIncludes);
        }
        catch (Exception e) {
            throw new AugeasRhqException((Throwable)e);
        }
    }

    public String getAugeasModuleName() {
        return this.module.getModuletName();
    }

    public List<String> getIncludes(File file) {
        ArrayList<String> includeFiles = new ArrayList<String>();
        return includeFiles;
    }

    public List<File> getAllConfigurationFiles() {
        return this.allConfigFiles;
    }

    private void loadIncludes(String expression, List<String> foundIncludes) {
        try {
            File file = new File(expression);
            List<File> files = new ArrayList<File>();
            if (!file.isAbsolute()) {
                File serverRootFile = new File(this.serverRootPath);
                files = Glob.match((File)serverRootFile, (String)expression);
            } else {
                files.add(file);
            }
            for (File fl : files) {
                String strLine;
                if (!fl.exists()) continue;
                foundIncludes.add(fl.getAbsolutePath());
                FileInputStream fstream = new FileInputStream(fl);
                BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
                while ((strLine = br.readLine()) != null) {
                    Matcher serverRootMatcher;
                    Matcher m = this.includePattern.matcher(strLine);
                    if (m.matches()) {
                        String glob = m.group(1);
                        this.module.addIncludedGlob(glob);
                        this.loadIncludes(glob, foundIncludes);
                    }
                    if (!(serverRootMatcher = this.serverRootPattern.matcher(strLine)).matches()) continue;
                    this.serverRootPath = serverRootMatcher.group(1);
                }
                br.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void loadFiles() {
        File root = new File(this.serverRootPath);
        for (AugeasModuleConfig module : this.modules) {
            List includeGlobs = module.getIncludedGlobs();
            if (includeGlobs.size() <= 0) {
                throw new IllegalStateException("Expecting at least once inclusion pattern for configuration files.");
            }
            ArrayList<File> files = new ArrayList<File>();
            for (String incl : includeGlobs) {
                if (incl.indexOf(File.separatorChar) == 0) {
                    files.add(new File(incl));
                    continue;
                }
                files.addAll(Glob.match((File)root, (String)incl));
            }
            if (module.getExcludedGlobs() != null) {
                List excludeGlobs = module.getExcludedGlobs();
                Glob.excludeAll(files, (List)excludeGlobs);
            }
            for (File configFile : files) {
                if (!configFile.isAbsolute()) {
                    throw new IllegalStateException("Configuration files inclusion patterns contain a non-absolute file.");
                }
                if (!configFile.exists()) {
                    throw new IllegalStateException("Configuration files inclusion patterns refer to a non-existent file.");
                }
                if (configFile.isDirectory()) {
                    throw new IllegalStateException("Configuration files inclusion patterns refer to a directory.");
                }
                if (module.getConfigFiles().contains(configFile.getAbsolutePath())) continue;
                module.addConfigFile(configFile.getAbsolutePath());
            }
        }
    }

    private static List<File> getIncludeFiles(String serverRoot, List<String> foundIncludes) {
        ArrayList<File> ret = new ArrayList<File>();
        File serverRootFile = new File(serverRoot);
        for (String path : foundIncludes) {
            File check = new File(path);
            if (check.isAbsolute()) {
                ret.add(check);
                continue;
            }
            for (File f : Glob.match((File)serverRootFile, (String)path)) {
                ret.add(f);
            }
        }
        return ret;
    }
}

