/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.apache.ApacheDirectoryComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheIfModuleDirectoryComponent
implements ResourceComponent<ApacheDirectoryComponent>,
ConfigurationFacet {
    private ResourceContext<ApacheDirectoryComponent> context;
    private ApacheDirectoryComponent parentComponent;
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String IFMODULE_DIRECTIVE_NAME = "<IfModule";

    public void start(ResourceContext<ApacheDirectoryComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        this.parentComponent = (ApacheDirectoryComponent)context.getParentResourceComponent();
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.parentComponent.getAvailability();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        ConfigurationDefinition resourceConfigDef = this.context.getResourceType().getResourceConfigurationDefinition();
        AugeasNode directoryNode = this.parentComponent.getNode();
        AugeasTree tree = this.parentComponent.getServerConfigurationTree();
        ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
        return mapping.updateConfiguration(this.getNode(directoryNode), resourceConfigDef);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        AugeasTree tree = null;
        try {
            tree = this.parentComponent.getServerConfigurationTree();
            ConfigurationDefinition resourceConfigDef = this.context.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode directoryNode = this.getNode(this.parentComponent.getNode());
            mapping.updateAugeas(directoryNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            this.log.info((Object)"Apache configuration was updated");
            ((ApacheDirectoryComponent)this.context.getParentResourceComponent()).finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                this.log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()));
            } else {
                this.log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    private AugeasNode getNode(AugeasNode virtualHost) {
        AugeasNode directory = AugeasNodeSearch.findNodeById(virtualHost, this.context.getResourceKey());
        return directory;
    }

    public boolean isAugeasEnabled() {
        return this.parentComponent.isAugeasEnabled();
    }
}

