/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheConfigWriter {
    public ApacheConfigWriter(ApacheDirectiveTree tree) {
    }

    private void findUpdated(ApacheDirective dir, List<ApacheDirective> updatedNodes) {
        if (dir.isUpdated()) {
            updatedNodes.add(dir);
        }
        for (ApacheDirective directive : dir.getChildDirectives()) {
            this.findUpdated(directive, updatedNodes);
        }
    }

    private Set<String> findUpdatedFiles(List<ApacheDirective> updatedNodes) {
        HashSet<String> updatedFiles = new HashSet<String>();
        for (ApacheDirective dir : updatedNodes) {
            updatedFiles.contains(dir.getFile());
        }
        return updatedFiles;
    }

    public void saveFile(String path) {
    }

    private ApacheDirective findFirstFileDirective(ApacheDirective node, String file) {
        if (node.getFile().equals(file)) {
            return node.getParentNode();
        }
        for (ApacheDirective dir : node.getChildDirectives()) {
            ApacheDirective dd = this.findFirstFileDirective(dir, file);
            if (dd == null) continue;
            return dd.getParentNode();
        }
        return null;
    }

    public void saveFile(String file, ApacheDirective dir) throws Exception {
        File fl = new File(file);
        if (!fl.exists()) {
            fl.createNewFile();
        }
        FileOutputStream str = new FileOutputStream(fl);
        for (ApacheDirective d : dir.getChildDirectives()) {
            if (!dir.getFile().equals(file)) continue;
            this.writeToFile(str, dir, file);
        }
    }

    private void writeToFile(OutputStream str, ApacheDirective dir, String file) throws Exception {
        if (dir.getFile().equals(file)) {
            str.write(dir.getText().getBytes());
            if (dir.isNested()) {
                for (ApacheDirective tempDir : dir.getChildDirectives()) {
                    this.writeToFile(str, tempDir, file);
                }
                str.write(("</" + dir.getName() + ">").getBytes());
            }
        } else {
            return;
        }
    }
}

