/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.augeas;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.augeas.Augeas;
import org.rhq.augeas.AugeasProxy;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeBuilder;
import org.rhq.augeas.util.Glob;
import org.rhq.plugins.apache.augeas.ApacheAugeasNode;
import org.rhq.plugins.apache.augeas.ApacheAugeasTree;
import org.rhq.plugins.apache.augeas.AugeasConfigurationApache;
import org.rhq.rhqtransform.AugeasRhqException;

public class AugeasTreeBuilderApache
implements AugeasTreeBuilder {
    private Map<String, List<File>> includes = new HashMap<String, List<File>>();
    private Map<AugeasNode, List<String>> incl = new HashMap<AugeasNode, List<String>>();
    private static final String[] NESTED_INCLUDE_DIRECTIVES = new String[]{"<VirtualHost", "<Directory"};
    private Augeas ag;

    public AugeasTree buildTree(AugeasProxy component, AugeasConfiguration config, String name, boolean lazy) throws AugeasRhqException {
        this.ag = component.getAugeas();
        AugeasConfigurationApache apacheConfig = (AugeasConfigurationApache)config;
        AugeasModuleConfig module = config.getModuleByName(name);
        ApacheAugeasTree tree = new ApacheAugeasTree(apacheConfig.getServerRootPath(), component.getAugeas(), module);
        List incld = module.getConfigFiles();
        if (incld.isEmpty()) {
            throw new AugeasRhqException("No configuration provided.");
        }
        String rootPath = (String)incld.get(0);
        ApacheAugeasNode rootNode = new ApacheAugeasNode("/files" + rootPath, (AugeasTree)tree);
        tree.setRootNode(rootNode);
        File rootFile = new File(apacheConfig.getServerRootPath());
        for (String inclName : module.getIncludedGlobs()) {
            ArrayList<File> files = new ArrayList<File>();
            if (inclName.indexOf(File.separatorChar) == 0) {
                files.add(new File(inclName));
            } else {
                files.addAll(Glob.match((File)rootFile, (String)inclName));
            }
            if (module.getExcludedGlobs() != null) {
                Glob.excludeAll(files, (List)module.getExcludedGlobs());
            }
            if (this.includes.containsKey(inclName)) continue;
            this.includes.put(inclName, files);
        }
        this.updateIncludes(rootNode, (AugeasTree)tree, rootPath, false);
        tree.setIncludes(this.incl);
        return tree;
    }

    public void updateIncludes(ApacheAugeasNode parentNode, AugeasTree tree, String fileName, boolean update) throws AugeasRhqException {
        List nestedNodes = this.ag.match("/files" + fileName + File.separator + "*");
        ArrayList<AugeasNode> createdNodes = new ArrayList<AugeasNode>();
        for (String nodeName : nestedNodes) {
            ApacheAugeasNode newNode = (ApacheAugeasNode)tree.createNode(nodeName);
            newNode.setParentNode(parentNode);
            createdNodes.add(newNode);
        }
        if (update) {
            parentNode.addIncludeNodes(createdNodes);
        }
        for (AugeasNode node : createdNodes) {
            String val;
            if (this.canContainIncludes(node.getLabel())) {
                String labelName = node.getLabel() + (node.getSeq() != 0 ? "[" + String.valueOf(node.getSeq()) + "]" : "");
                this.updateIncludes((ApacheAugeasNode)node, tree, fileName + File.separator + labelName, false);
            }
            if (!node.getLabel().equals("Include") || !this.includes.containsKey(val = this.ag.get(node.getFullPath() + File.separator + "param"))) continue;
            List<File> files = this.includes.get(val);
            ArrayList<String> names = new ArrayList<String>();
            for (File file : files) {
                names.add("/files" + file.getAbsolutePath());
                this.updateIncludes((ApacheAugeasNode)node.getParentNode(), tree, file.getAbsolutePath(), true);
            }
            if (this.incl.containsKey(node.getParentNode())) {
                List<String> list = this.incl.get(node.getParentNode());
                list.addAll(names);
                continue;
            }
            this.incl.put(node.getParentNode(), names);
        }
    }

    private boolean canContainIncludes(String name) {
        for (String directive : NESTED_INCLUDE_DIRECTIVES) {
            if (!directive.equals(name)) continue;
            return true;
        }
        return false;
    }
}

