/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.AugeasNodeSearch;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;
import org.rhq.plugins.apache.util.ConfigurationTimestamp;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;
import org.rhq.plugins.www.util.WWWUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheVirtualHostServiceComponent
implements ResourceComponent<ApacheServerComponent>,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet,
CreateChildResourceFacet {
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceComponent.class);
    public static final String URL_CONFIG_PROP = "url";
    public static final String MAIN_SERVER_RESOURCE_KEY = "MainServer";
    public static final String RESPONSE_TIME_LOG_FILE_CONFIG_PROP = "responseTimeLogFile";
    public static final String RESPONSE_TIME_URL_EXCLUDES_CONFIG_PROP = "responseTimeUrlExcludes";
    public static final String RESPONSE_TIME_URL_TRANSFORMS_CONFIG_PROP = "responseTimeUrlTransforms";
    public static final String SERVER_NAME_CONFIG_PROP = "ServerName";
    private static final String RESPONSE_TIME_METRIC = "ResponseTime";
    private static final double RESPONSE_TIME_LOG_TIME_MULTIPLIER = 0.001;
    private ResourceContext<ApacheServerComponent> resourceContext;
    private URL url;
    private ResponseTimeLogParser logParser;
    private ConfigurationTimestamp lastConfigurationTimeStamp = new ConfigurationTimestamp();
    private int snmpWwwServiceIndex = -1;
    public static final String RESOURCE_TYPE_NAME = "Apache Virtual Host";

    public void start(ResourceContext<ApacheServerComponent> resourceContext) throws Exception {
        ResponseTimeConfiguration responseTimeConfig;
        File logFile;
        this.resourceContext = resourceContext;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String url = pluginConfig.getSimple(URL_CONFIG_PROP).getStringValue();
        if (url != null) {
            try {
                this.url = new URL(url);
                if (this.url.getPort() == 0) {
                    throw new InvalidPluginConfigurationException("The 'url' connection property is invalid - 0 is not a valid port; please change the value to the port this virtual host is listening on. NOTE: If the 'url' property was set this way after autodiscovery, you most likely did not include the port in the ServerName directive for this virtual host in httpd.conf.");
                }
            }
            catch (MalformedURLException e) {
                throw new Exception("Value of 'url' connection property ('" + url + "') is not a valid URL.");
            }
        }
        if ((logFile = (responseTimeConfig = new ResponseTimeConfiguration(pluginConfig)).getLogFile()) != null) {
            this.logParser = new ResponseTimeLogParser(logFile, 0.001);
            this.logParser.setExcludes(responseTimeConfig.getExcludes());
            this.logParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    public void stop() {
        this.resourceContext = null;
        this.url = null;
    }

    public AvailabilityType getAvailability() {
        return this.url != null && WWWUtils.isAvailable(this.url) ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        ApacheServerComponent parent = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        if (!parent.isAugeasEnabled()) {
            throw new Exception("Configuration is supported only for Apache version 2 and up using Augeas. You either have an old version of Apache or Augeas is not installed.");
        }
        AugeasTree tree = this.getServerConfigurationTree();
        ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
        return mapping.updateConfiguration(this.getNode(tree), resourceConfigDef);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        AugeasTree tree = null;
        try {
            tree = this.getServerConfigurationTree();
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode virtHostNode = this.getNode(tree);
            mapping.updateAugeas(virtHostNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            log.info((Object)"Apache configuration was updated");
            this.finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()));
            } else {
                log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public void deleteResource() throws Exception {
        ApacheServerComponent parent = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        if (!parent.isAugeasEnabled()) {
            throw new Exception("Configuration is supported only for Apache version 2 and up using Augeas. You either have an old version of Apache or Augeas is not installed.");
        }
        if (MAIN_SERVER_RESOURCE_KEY.equals(this.resourceContext.getResourceKey())) {
            throw new IllegalArgumentException("Cannot delete the virtual host representing the main server configuration.");
        }
        AugeasTree tree = this.getServerConfigurationTree();
        try {
            AugeasNode myNode = this.getNode(this.getServerConfigurationTree());
            tree.removeNode(myNode, true);
            tree.save();
            this.deleteEmptyFile(tree, myNode);
            this.conditionalRestart();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) throws Exception {
        int primaryIndex = this.getWwwServiceIndex();
        if (primaryIndex < 0) {
            return;
        }
        log.debug((Object)("Collecting metrics for VirtualHost service #" + primaryIndex + "..."));
        SNMPSession snmpSession = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getSNMPSession();
        if (!snmpSession.ping()) {
            log.debug((Object)("Failed to connect to SNMP agent at " + snmpSession + " - aborting metric collection..."));
            return;
        }
        for (MeasurementScheduleRequest schedule : schedules) {
            String metricName = schedule.getName();
            if (metricName.equals(RESPONSE_TIME_METRIC)) {
                if (this.logParser != null) {
                    try {
                        CallTimeData callTimeData = new CallTimeData(schedule);
                        this.logParser.parseLog(callTimeData);
                        report.addData(callTimeData);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve HTTP call-time data.", (Throwable)e);
                    }
                    continue;
                }
                log.error((Object)("The 'ResponseTime' metric is enabled for resource '" + this.resourceContext.getResourceKey() + "', but no value is defined for the '" + RESPONSE_TIME_LOG_FILE_CONFIG_PROP + "' connection property."));
                continue;
            }
            try {
                this.collectSnmpMetric(report, primaryIndex, snmpSession, schedule);
            }
            catch (SNMPException e) {
                log.error((Object)"An error occurred while attempting to collect an SNMP metric.", (Throwable)e);
            }
        }
        log.info((Object)("Collected " + report.getDataCount() + " metrics for VirtualHost " + this.resourceContext.getResourceKey() + "."));
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage("Resources can be created only when augeas is enabled.");
            return report;
        }
        ResourceType resourceType = report.getResourceType();
        if (resourceType.equals((Object)this.getDirectoryResourceType())) {
            Configuration resourceConfiguration = report.getResourceConfiguration();
            Configuration pluginConfiguration = report.getPluginConfiguration();
            String directoryName = report.getUserSpecifiedResourceName();
            AugeasTree tree = this.getServerConfigurationTree();
            AugeasNode myNode = this.getNode(tree);
            List directories = myNode.getChildByLabel("<Directory");
            int seq = 1;
            for (AugeasNode n : directories) {
                String param = n.getFullPath();
                int end = param.lastIndexOf(File.separatorChar);
                if (end == -1 || !myNode.getFullPath().equals(param.substring(0, end))) continue;
                ++seq;
            }
            pluginConfiguration.put((Property)new PropertySimple("regexp", (Object)false));
            String dirNameToSet = AugeasNodeValueUtil.escape(directoryName);
            try {
                ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
                AugeasNode directoryNode = tree.createNode(myNode, "<Directory", null, seq);
                tree.createNode(directoryNode, "param", dirNameToSet, 0);
                mapping.updateAugeas(directoryNode, resourceConfiguration, resourceType.getResourceConfigurationDefinition());
                tree.save();
                tree = this.getServerConfigurationTree();
                String key = AugeasNodeSearch.getNodeKey(myNode, directoryNode);
                report.setResourceKey(key);
                report.setResourceName(directoryName);
                report.setStatus(CreateResourceStatus.SUCCESS);
                ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).finishChildResourceCreate(report);
            }
            catch (Exception e) {
                report.setException((Throwable)e);
                report.setStatus(CreateResourceStatus.FAILURE);
            }
        } else {
            report.setErrorMessage("Unable to create resources of type " + resourceType.getName());
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        return report;
    }

    public AugeasTree getServerConfigurationTree() {
        return ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getAugeasTree();
    }

    public AugeasNode getNode(AugeasTree tree) {
        String resourceKey = this.resourceContext.getResourceKey();
        if (MAIN_SERVER_RESOURCE_KEY.equals(resourceKey)) {
            return tree.getRootNode();
        }
        String serverName = null;
        int pipeIdx = resourceKey.indexOf(124);
        if (pipeIdx >= 0) {
            serverName = resourceKey.substring(0, pipeIdx);
        }
        String[] addrs = resourceKey.substring(pipeIdx + 1).split(" ");
        List nodes = tree.matchRelative(tree.getRootNode(), "<VirtualHost");
        ArrayList virtualHosts = new ArrayList();
        boolean updated = false;
        HttpdAddressUtility.Address resourceKeyAddress = HttpdAddressUtility.Address.parse(resourceKey);
        AugeasNode bestNode = null;
        int bestMatch = 0;
        for (AugeasNode node : nodes) {
            List vhostAddressNodes = node.getChildByLabel("param");
            ArrayList<HttpdAddressUtility.Address> vhostAddresses = new ArrayList<HttpdAddressUtility.Address>();
            for (AugeasNode vhostAddressNode : vhostAddressNodes) {
                vhostAddresses.add(HttpdAddressUtility.Address.parse(vhostAddressNode.getValue()));
            }
            int matchRate = ApacheVirtualHostServiceComponent.matchRate(vhostAddresses, resourceKeyAddress);
            if (bestMatch >= matchRate) continue;
            bestNode = node;
        }
        if (bestNode != null) {
            return bestNode;
        }
        try {
            String serverUrl = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getServerUrl();
            URI serverUri = new URI(serverUrl);
            String expectedResourceKey = serverUri.getHost() + ":" + serverUri.getPort();
            HttpdAddressUtility.Address expectedAddress = HttpdAddressUtility.Address.parse(expectedResourceKey);
            HttpdAddressUtility.Address actualAddress = HttpdAddressUtility.Address.parse(resourceKey);
            if (ApacheVirtualHostServiceComponent.matchRate(Collections.singletonList(expectedAddress), actualAddress) > 0) {
                return tree.getRootNode();
            }
        }
        catch (URISyntaxException e) {
            log.warn((Object)"Failed to parse the server URL when trying to match the vhost with the main server.", (Throwable)e);
        }
        throw new IllegalStateException("Could not find virtual host configuration in augeas for virtual host: " + resourceKey);
    }

    public void finishConfigurationUpdate(ConfigurationUpdateReport report) {
        ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).finishConfigurationUpdate(report);
    }

    public void conditionalRestart() throws Exception {
        ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).conditionalRestart();
    }

    public void deleteEmptyFile(AugeasTree tree, AugeasNode deletedNode) {
        ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).deleteEmptyFile(tree, deletedNode);
    }

    private void collectSnmpMetric(MeasurementReport report, int primaryIndex, SNMPSession snmpSession, MeasurementScheduleRequest schedule) throws SNMPException {
        SNMPValue snmpValue = null;
        String metricName = schedule.getName();
        int dotIndex = metricName.indexOf(46);
        if (dotIndex == -1) {
            String mibName = metricName;
            List<SNMPValue> snmpValues = snmpSession.getColumn(mibName);
            snmpValue = snmpValues.get(primaryIndex - 1);
        } else {
            String oid;
            String mibName = metricName.substring(0, dotIndex);
            String mibSecondaryIndex = metricName.substring(dotIndex + 1);
            try {
                Integer.parseInt(mibSecondaryIndex);
                oid = mibSecondaryIndex;
            }
            catch (NumberFormatException e) {
                oid = this.convertStringToOid(mibSecondaryIndex);
            }
            boolean found = false;
            Map<String, SNMPValue> table = snmpSession.getTable(mibName, primaryIndex);
            if (table != null && (snmpValue = table.get(oid)) != null) {
                found = true;
            }
            if (!found) {
                log.error((Object)("Entry '" + oid + "' not found for " + mibName + "[" + primaryIndex + "]."));
                log.error((Object)("Table:\n" + table));
                return;
            }
        }
        log.debug((Object)("Collected SNMP metric [" + metricName + "], value = " + snmpValue));
        boolean valueIsTimestamp = false;
        ApacheServerComponent.addSnmpMetricValueToReport(report, schedule, snmpValue, valueIsTimestamp);
    }

    private String convertStringToOid(String string) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(string.length());
        for (int i = 0; i < string.length(); ++i) {
            strBuf.append('.').append((byte)string.charAt(i));
        }
        String oid = strBuf.toString();
        return oid;
    }

    public static int getMatchingWwwServiceIndex(ApacheServerComponent parent, String resourceKey, List<SNMPValue> names, List<SNMPValue> ports) {
        int ret = -1;
        Iterator<SNMPValue> namesIterator = names.iterator();
        Iterator<SNMPValue> portsIterator = ports.iterator();
        String vhostServerName = null;
        String[] vhostAddressStrings = null;
        int pipeIdx = resourceKey.indexOf(124);
        if (pipeIdx >= 0) {
            vhostServerName = resourceKey.substring(0, pipeIdx);
        }
        vhostAddressStrings = resourceKey.substring(pipeIdx + 1).split(" ");
        ApacheDirectiveTree tree = parent.loadParser();
        ArrayList<HttpdAddressUtility.Address> vhostAddresses = new ArrayList<HttpdAddressUtility.Address>(vhostAddressStrings.length);
        if (vhostAddressStrings.length == 1 && MAIN_SERVER_RESOURCE_KEY.equals(vhostAddressStrings[0])) {
            HttpdAddressUtility.Address serverAddr = parent.getAddressUtility().getMainServerSampleAddress(tree, null, 0);
            if (serverAddr != null) {
                vhostAddresses.add(serverAddr);
            }
        } else {
            for (int i = 0; i < vhostAddressStrings.length; ++i) {
                HttpdAddressUtility.Address vhostAddr = parent.getAddressUtility().getVirtualHostSampleAddress(tree, vhostAddressStrings[i], vhostServerName, true);
                if (vhostAddr != null) {
                    vhostAddresses.add(vhostAddr);
                    continue;
                }
                HttpdAddressUtility.Address addr = HttpdAddressUtility.Address.parse(vhostAddressStrings[i]);
                vhostAddr = parent.getAddressUtility().getMainServerSampleAddress(tree, addr.host, addr.port);
                if (vhostAddr == null) continue;
                vhostAddresses.add(vhostAddr);
            }
        }
        SNMPValue bestMatch = null;
        int bestMatchRate = 0;
        while (namesIterator.hasNext()) {
            String fullPort;
            int snmpPort;
            SNMPValue nameValue = namesIterator.next();
            SNMPValue portValue = portsIterator.next();
            String snmpHost = nameValue.toString();
            HttpdAddressUtility.Address snmpAddress = new HttpdAddressUtility.Address(snmpHost, snmpPort = Integer.parseInt((fullPort = portValue.toString()).substring(fullPort.lastIndexOf(".") + 1)));
            int matchRate = ApacheVirtualHostServiceComponent.matchRate(vhostAddresses, snmpAddress);
            if (matchRate <= bestMatchRate) continue;
            bestMatch = nameValue;
            bestMatchRate = matchRate;
        }
        if (bestMatch != null) {
            String nameOID = bestMatch.getOID();
            ret = Integer.parseInt(nameOID.substring(nameOID.lastIndexOf(".") + 1));
        } else {
            log.warn((Object)("Unable to match the Virtual Host [" + resourceKey + "] with any of the SNMP advertised vhosts: " + names + ". It won't be possible to monitor the Virtual Host."));
        }
        return ret;
    }

    private int getWwwServiceIndex() throws Exception {
        ConfigurationTimestamp currentTimestamp = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getConfigurationTimestamp();
        if (!this.lastConfigurationTimeStamp.equals(currentTimestamp)) {
            this.snmpWwwServiceIndex = -1;
            this.lastConfigurationTimeStamp = currentTimestamp;
            SNMPSession snmpSession = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getSNMPSession();
            List<SNMPValue> names = snmpSession.getColumn("wwwServiceName");
            List<SNMPValue> ports = snmpSession.getColumn("wwwServiceProtocol");
            this.snmpWwwServiceIndex = ApacheVirtualHostServiceComponent.getMatchingWwwServiceIndex((ApacheServerComponent)this.resourceContext.getParentResourceComponent(), this.resourceContext.getResourceKey(), names, ports);
        }
        return this.snmpWwwServiceIndex;
    }

    private static int matchRate(List<HttpdAddressUtility.Address> addresses, HttpdAddressUtility.Address addressToCheck) {
        InetAddress[] ipAddresses;
        for (HttpdAddressUtility.Address a : addresses) {
            if (!HttpdAddressUtility.isAddressConforming(addressToCheck, a.host, a.port, true)) continue;
            return 3;
        }
        try {
            for (InetAddress ip : ipAddresses = InetAddress.getAllByName(addressToCheck.host)) {
                HttpdAddressUtility.Address newCheck = new HttpdAddressUtility.Address(ip.getHostAddress(), addressToCheck.port);
                for (HttpdAddressUtility.Address a : addresses) {
                    if (!HttpdAddressUtility.isAddressConforming(newCheck, a.host, a.port, true)) continue;
                    return 2;
                }
            }
        }
        catch (UnknownHostException e) {
            log.debug((Object)("Unknown host encountered in the httpd configuration: " + addressToCheck.host));
            return 0;
        }
        int addressPort = addressToCheck.port;
        if (addressPort == 80) {
            addressPort = 0;
        }
        for (HttpdAddressUtility.Address listAddress : addresses) {
            InetAddress[] listAddresses;
            int listPort = listAddress.port;
            if (listPort == 80) {
                listPort = 0;
            }
            try {
                listAddresses = InetAddress.getAllByName(listAddress.host);
            }
            catch (UnknownHostException e) {
                log.debug((Object)("Unknown host encountered in the httpd configuration: " + listAddress.host));
                return 0;
            }
            for (InetAddress listInetAddr : listAddresses) {
                for (InetAddress ip : ipAddresses) {
                    if (!ip.equals(listInetAddr) || addressPort != listPort) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    private ResourceType getDirectoryResourceType() {
        return (ResourceType)this.resourceContext.getResourceType().getChildResourceTypes().iterator().next();
    }

    public ApacheDirectiveTree loadParser() throws Exception {
        return ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).loadParser();
    }

    public boolean isAugeasEnabled() {
        ApacheServerComponent parent = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        return parent.isAugeasEnabled();
    }
}

