/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpdAddressUtility {
    APACHE_1_3{

        public Address getMainServerSampleAddress(ApacheDirectiveTree ag, String limitToHost, int limitToPort) {
            try {
                List<String> values;
                List<ApacheDirective> ports = ag.search("/Port");
                List<ApacheDirective> bindAddresses = ag.search("/BindAddress");
                List<ApacheDirective> listens = ag.search("/Listen");
                String port = "80";
                String bindAddress = null;
                ArrayList<Address> addressesToMatch = new ArrayList<Address>();
                if (ports.size() > 0 && (values = ports.get(0).getValues()).size() > 0) {
                    port = values.get(0);
                }
                if (bindAddresses.size() > 0 && (values = bindAddresses.get(0).getValues()).size() > 0) {
                    bindAddress = values.get(0);
                }
                if (listens.size() > 0) {
                    for (ApacheDirective l : listens) {
                        addressesToMatch.add(HttpdAddressUtility.parseListen(l.getValues().get(0)));
                    }
                } else {
                    addressesToMatch.add(new Address(bindAddress, Integer.parseInt(port)));
                }
                for (Address address : addressesToMatch) {
                    if (!1.isAddressConforming(address, limitToHost, limitToPort, false)) continue;
                    if (!address.isPortDefined() || address.isPortWildcard()) {
                        address.port = 80;
                    }
                    if (address.host == null || address.isHostDefault() || address.isHostWildcard()) {
                        address = HttpdAddressUtility.getLocalhost(address.port);
                    }
                    HttpdAddressUtility.updateWithServerName(address, ag);
                    return address;
                }
                return null;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to obtain main server address.", (Throwable)e);
                return null;
            }
        }
    }
    ,
    APACHE_2_x{

        public Address getMainServerSampleAddress(ApacheDirectiveTree ag, String limitToHost, int limitToPort) {
            try {
                for (ApacheDirective n : ag.search("/Listen")) {
                    Address addr = HttpdAddressUtility.parseListen(n.getValues().get(0));
                    if (!2.isAddressConforming(addr, limitToHost, limitToPort, false)) continue;
                    if (addr.host == null || addr.isHostDefault() || addr.isHostWildcard()) {
                        addr = HttpdAddressUtility.getLocalhost(addr.port);
                    }
                    HttpdAddressUtility.updateWithServerName(addr, ag);
                    return addr;
                }
                throw new IllegalStateException("Could find a listen address on port " + limitToPort);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to obtain main server address.", (Throwable)e);
                return null;
            }
        }
    };

    private static final Log log;

    public static HttpdAddressUtility get(String version) {
        return version.startsWith("1.") ? APACHE_1_3 : APACHE_2_x;
    }

    public abstract Address getMainServerSampleAddress(ApacheDirectiveTree var1, String var2, int var3);

    public Address getVirtualHostSampleAddress(ApacheDirectiveTree ag, String virtualHost, String serverName, boolean snmpModuleCompatibleMode) {
        try {
            Address addr = Address.parse(virtualHost);
            if (addr.isHostDefault() || addr.isHostWildcard()) {
                Address serverAddr = null;
                serverAddr = snmpModuleCompatibleMode ? HttpdAddressUtility.getLocalhost(addr.port) : this.getMainServerSampleAddress(ag, null, addr.port);
                if (serverAddr == null) {
                    return null;
                }
                addr.host = serverAddr.host;
            }
            if (serverName != null) {
                HttpdAddressUtility.updateWithServerName(addr, serverName);
            }
            return addr;
        }
        catch (Exception e) {
            log.warn((Object)"Failed to obtain virtual host address.", (Throwable)e);
            return null;
        }
    }

    private static Address parseListen(String listenValue) {
        Address ret = Address.parse(listenValue);
        if (!ret.isPortDefined()) {
            try {
                ret.port = Integer.parseInt(ret.host);
            }
            catch (NumberFormatException e) {
                return null;
            }
            ret.host = null;
        }
        return ret;
    }

    public static boolean isAddressConforming(Address listen, String limitingHost, int limitingPort, boolean snmpModuleCompatibleMode) {
        boolean portOk;
        if ("_default_".equals(limitingHost) || "*".equals(limitingHost)) {
            limitingHost = null;
        }
        boolean hostOk = limitingHost == null;
        boolean bl = portOk = limitingPort <= 0;
        if (!hostOk && (listen.host == null || limitingHost.equals(listen.host))) {
            hostOk = true;
        }
        int listenPort = listen.port;
        if (snmpModuleCompatibleMode) {
            if (limitingPort == 80) {
                limitingPort = 0;
            }
            if (listenPort == 80) {
                listenPort = 0;
            }
        }
        if (!portOk && limitingPort == listenPort) {
            portOk = true;
        }
        return hostOk && portOk;
    }

    private static Address getLocalhost(int port) {
        try {
            return new Address(InetAddress.getLocalHost().getHostAddress(), port);
        }
        catch (UnknownHostException e) {
            return new Address("127.0.0.1", port);
        }
    }

    private static void updateWithServerName(Address address, ApacheDirectiveTree config) throws UnknownHostException {
        List<ApacheDirective> serverNameNodes = config.search("/ServerName");
        if (serverNameNodes.size() > 0) {
            String serverName = serverNameNodes.get(0).getValuesAsString();
            HttpdAddressUtility.updateWithServerName(address, serverName);
        }
    }

    private static void updateWithServerName(Address address, String serverName) throws UnknownHostException {
        Address serverAddr = Address.parse(serverName);
        String ipFromServerName = null;
        String ipFromAddress = null;
        String hostFromServerName = null;
        String hostFromAddress = null;
        boolean lookupFailed = false;
        try {
            InetAddress addrFromServerName = InetAddress.getByName(serverAddr.host);
            ipFromServerName = addrFromServerName.getHostAddress();
            hostFromServerName = addrFromServerName.getHostName();
        }
        catch (UnknownHostException e) {
            ipFromServerName = serverAddr.host;
            hostFromServerName = serverAddr.host;
            lookupFailed = true;
        }
        try {
            InetAddress addrFromAddress = InetAddress.getByName(address.host);
            ipFromAddress = addrFromAddress.getHostAddress();
            hostFromAddress = addrFromAddress.getHostName();
        }
        catch (UnknownHostException e) {
            ipFromAddress = address.host;
            hostFromAddress = address.host;
            lookupFailed = true;
        }
        if (ipFromAddress.equals(ipFromServerName) || lookupFailed && hostFromAddress.equals(hostFromServerName)) {
            address.scheme = serverAddr.scheme;
            address.host = serverAddr.host;
        }
    }

    static {
        log = LogFactory.getLog(HttpdAddressUtility.class);
    }

    public static class Address {
        public String host;
        public int port = -1;
        public String scheme = "http";
        public static final String WILDCARD = "*";
        public static final String DEFAULT_HOST = "_default_";
        public static final int PORT_WILDCARD_VALUE = 0;
        public static final int NO_PORT_SPECIFIED_VALUE = -1;

        public Address(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Address(String scheme, String host, int port) {
            this(host, port);
            this.scheme = scheme;
        }

        public static Address parse(String address) {
            int lastColonIdx;
            String scheme = "http";
            int schemeSpecIdx = address.indexOf("://");
            if (schemeSpecIdx >= 0) {
                scheme = address.substring(0, schemeSpecIdx);
                address = address.substring(schemeSpecIdx + "://".length());
            }
            if ((lastColonIdx = address.lastIndexOf(58)) == -1) {
                return new Address(address, -1);
            }
            int lastRightBracketPos = address.lastIndexOf(93);
            if (lastColonIdx > lastRightBracketPos) {
                String host = address.substring(0, lastColonIdx);
                String portSpec = address.substring(lastColonIdx + 1);
                int port = -1;
                port = WILDCARD.equals(portSpec) ? 0 : Integer.parseInt(portSpec);
                return new Address(scheme, host, port);
            }
            return new Address(scheme, address, -1);
        }

        public boolean isPortWildcard() {
            return this.port == 0;
        }

        public boolean isPortDefined() {
            return this.port != -1;
        }

        public boolean isHostWildcard() {
            return WILDCARD.equals(this.host);
        }

        public boolean isHostDefault() {
            return DEFAULT_HOST.equals(this.host);
        }

        public int hashCode() {
            int hash = this.port;
            if (this.host != null) {
                hash *= this.host.hashCode();
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Address)) {
                return false;
            }
            Address o = (Address)other;
            return Address.safeEquals(this.host, o.host) && this.port == o.port;
        }

        public boolean matches(Address other, boolean matchSchemes) {
            if (matchSchemes && !Address.safeEquals(this.scheme, other.scheme)) {
                return false;
            }
            if (!(WILDCARD.equals(this.host) || WILDCARD.equals(other.host) || Address.safeEquals(this.host, other.host))) {
                return false;
            }
            return 0 == this.port || 0 == other.port || this.port == other.port;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean includeScheme) {
            StringBuilder bld = new StringBuilder();
            if (includeScheme) {
                bld.append(this.scheme).append("://");
            }
            bld.append(this.host);
            if (this.port != -1) {
                bld.append(":");
                if (this.port == 0) {
                    bld.append(WILDCARD);
                } else {
                    bld.append(this.port);
                }
            }
            return bld.toString();
        }

        private static boolean safeEquals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

