/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;

public enum HttpdAddressUtility {
    APACHE_1_3{

        @Override
        public List<Address> getAllMainServerAddresses(ApacheDirectiveTree ag, boolean substituteWildcards) {
            try {
                List<String> values;
                List<ApacheDirective> ports = ag.search("/Port");
                List<ApacheDirective> bindAddresses = ag.search("/BindAddress");
                List<ApacheDirective> listens = ag.search("/Listen");
                String port = "80";
                String bindAddress = null;
                ArrayList<Address> addresses = new ArrayList<Address>();
                if (ports.size() > 0 && (values = ports.get(0).getValues()).size() > 0) {
                    port = values.get(0);
                }
                if (bindAddresses.size() > 0 && (values = bindAddresses.get(0).getValues()).size() > 0) {
                    bindAddress = values.get(0);
                }
                if (listens.size() > 0) {
                    for (ApacheDirective l : listens) {
                        addresses.add(HttpdAddressUtility.parseListen(l.getValues().get(0)));
                    }
                } else {
                    addresses.add(new Address(bindAddress, Integer.parseInt(port)));
                }
                for (Address address : addresses) {
                    if (!address.isPortDefined()) {
                        address.port = 80;
                    }
                    if (!substituteWildcards) continue;
                    HttpdAddressUtility.substituteWildcards(ag, address);
                }
                return addresses;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to obtain main server address.", (Throwable)e);
                return null;
            }
        }
    }
    ,
    APACHE_2_x{

        @Override
        public List<Address> getAllMainServerAddresses(ApacheDirectiveTree ag, boolean substituteWildcards) {
            try {
                ArrayList<Address> ret = new ArrayList<Address>();
                for (ApacheDirective n : ag.search("/Listen")) {
                    Address addr = HttpdAddressUtility.parseListen(n.getValues().get(0));
                    if (substituteWildcards) {
                        HttpdAddressUtility.substituteWildcards(ag, addr);
                    }
                    ret.add(addr);
                }
                return ret;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to obtain main server address.", (Throwable)e);
                return null;
            }
        }
    };

    private static final Log log;
    public static final String BOGUS_HOST_WITHOUT_FORWARD_DNS = "bogus_host_without_forward_dns";
    public static final String BOGUS_HOST_WITHOUT_REVERSE_DNS = "bogus_host_without_reverse_dns";

    public static HttpdAddressUtility get(String version) {
        return version.startsWith("1.") ? APACHE_1_3 : APACHE_2_x;
    }

    public abstract List<Address> getAllMainServerAddresses(ApacheDirectiveTree var1, boolean var2);

    public Address getMainServerSampleAddress(ApacheDirectiveTree ag, String limitToHost, int limitToPort) {
        List<Address> addressesToMatch = this.getAllMainServerAddresses(ag, false);
        if (addressesToMatch == null) {
            return null;
        }
        for (Address address : addressesToMatch) {
            if (!HttpdAddressUtility.isAddressConforming(address, limitToHost, limitToPort, false)) continue;
            HttpdAddressUtility.substituteWildcards(ag, address);
            return address;
        }
        return null;
    }

    public Address getVirtualHostSampleAddress(ApacheDirectiveTree ag, String virtualHost, String serverName) {
        try {
            Address addr = Address.parse(virtualHost);
            if (addr.isHostDefault() || addr.isHostWildcard()) {
                Address serverAddr = null;
                serverAddr = this.getMainServerSampleAddress(ag, null, addr.port);
                if (serverAddr == null) {
                    return null;
                }
                addr.host = serverAddr.host;
            }
            if (serverName != null) {
                HttpdAddressUtility.updateWithServerName(addr, serverName);
            }
            return addr;
        }
        catch (Exception e) {
            log.warn((Object)"Failed to obtain virtual host address.", (Throwable)e);
            return null;
        }
    }

    public Address getHttpdInternalMainServerAddressRepresentation(ApacheDirectiveTree runtimeConfig) {
        Address ret = null;
        List<ApacheDirective> serverNames = runtimeConfig.search("/ServerName");
        if (serverNames.size() == 0) {
            ret = new Address("*", -1);
            try {
                ret.host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                ret.host = "127.0.0.1";
            }
            ret.port = 0;
        } else {
            String serverName = serverNames.get(serverNames.size() - 1).getValuesAsString();
            ret = Address.parse(serverName);
            if (!ret.isPortDefined()) {
                ret.port = 0;
            }
        }
        return ret;
    }

    public Address getHttpdInternalVirtualHostAddressRepresentation(ApacheDirectiveTree runtimeConfig, String virtualHost, String serverName) {
        Address ret = null;
        if (serverName != null) {
            ret = Address.parse(serverName);
            if (!ret.isPortDefined()) {
                ret.port = 0;
            }
        } else {
            ret = Address.parse(virtualHost);
            if (!ret.isPortDefined() || ret.isPortWildcard() || ret.isHostDefault() || ret.isHostWildcard()) {
                Address mainAddress = this.getHttpdInternalMainServerAddressRepresentation(runtimeConfig);
                if (!ret.isPortDefined() || ret.isPortWildcard()) {
                    ret.port = mainAddress.port;
                }
                if (ret.isHostDefault() || ret.isHostWildcard()) {
                    ret.host = mainAddress.host;
                }
            }
            try {
                InetAddress iAddr = InetAddress.getByName(ret.host);
                String reverseLookup = iAddr.getHostName();
                ret.host = iAddr.getHostAddress().equals(reverseLookup) ? BOGUS_HOST_WITHOUT_REVERSE_DNS : reverseLookup;
            }
            catch (UnknownHostException e) {
                ret.host = BOGUS_HOST_WITHOUT_FORWARD_DNS;
            }
        }
        return ret;
    }

    private static Address parseListen(String listenValue) {
        Address ret = Address.parse(listenValue);
        if (!ret.isPortDefined()) {
            try {
                ret.port = Integer.parseInt(ret.host);
            }
            catch (NumberFormatException e) {
                return null;
            }
            ret.host = null;
        }
        return ret;
    }

    private static void substituteWildcards(ApacheDirectiveTree ag, Address address) {
        if (address.isPortWildcard()) {
            address.port = 80;
        }
        if (address.host == null || address.isHostDefault() || address.isHostWildcard()) {
            Address localhost = HttpdAddressUtility.getLocalhost(address.port);
            address.host = localhost.host;
        }
        HttpdAddressUtility.updateWithServerName(address, ag);
    }

    private static boolean isAddressConforming(Address listen, String limitingHost, int limitingPort, boolean snmpModuleCompatibleMode) {
        boolean portOk;
        if ("_default_".equals(limitingHost) || "*".equals(limitingHost)) {
            limitingHost = null;
        }
        boolean hostOk = limitingHost == null;
        boolean bl = portOk = limitingPort <= 0;
        if (!hostOk && (listen.host == null || limitingHost.equals(listen.host))) {
            hostOk = true;
        }
        int listenPort = listen.port;
        if (snmpModuleCompatibleMode) {
            if (limitingPort == 80) {
                limitingPort = 0;
            }
            if (listenPort == 80) {
                listenPort = 0;
            }
        }
        if (!portOk && limitingPort == listenPort) {
            portOk = true;
        }
        return hostOk && portOk;
    }

    private static Address getLocalhost(int port) {
        try {
            return new Address(InetAddress.getLocalHost().getHostAddress(), port);
        }
        catch (UnknownHostException e) {
            return new Address("127.0.0.1", port);
        }
    }

    private static void updateWithServerName(Address address, ApacheDirectiveTree config) {
        List<ApacheDirective> serverNameNodes = config.search("/ServerName");
        if (serverNameNodes.size() > 0) {
            String serverName = serverNameNodes.get(0).getValuesAsString();
            HttpdAddressUtility.updateWithServerName(address, serverName);
        }
    }

    private static void updateWithServerName(Address address, String serverName) {
        Address serverAddr = Address.parse(serverName);
        String ipFromServerName = null;
        String ipFromAddress = null;
        String hostFromServerName = null;
        String hostFromAddress = null;
        boolean lookupFailed = false;
        try {
            InetAddress addrFromServerName = InetAddress.getByName(serverAddr.host);
            ipFromServerName = addrFromServerName.getHostAddress();
            hostFromServerName = addrFromServerName.getHostName();
        }
        catch (UnknownHostException e) {
            ipFromServerName = serverAddr.host;
            hostFromServerName = serverAddr.host;
            lookupFailed = true;
        }
        try {
            InetAddress addrFromAddress = InetAddress.getByName(address.host);
            ipFromAddress = addrFromAddress.getHostAddress();
            hostFromAddress = addrFromAddress.getHostName();
        }
        catch (UnknownHostException e) {
            ipFromAddress = address.host;
            hostFromAddress = address.host;
            lookupFailed = true;
        }
        if (ipFromAddress.equals(ipFromServerName) || lookupFailed && hostFromAddress.equals(hostFromServerName)) {
            address.scheme = serverAddr.scheme;
            address.host = serverAddr.host;
        }
    }

    static {
        log = LogFactory.getLog(HttpdAddressUtility.class);
    }

    public static class Address {
        public String host;
        public int port = -1;
        public String scheme = "http";
        public static final String WILDCARD = "*";
        public static final String DEFAULT_HOST = "_default_";
        public static final int PORT_WILDCARD_VALUE = 0;
        public static final int NO_PORT_SPECIFIED_VALUE = -1;

        public Address(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Address(String scheme, String host, int port) {
            this(host, port);
            this.scheme = scheme;
        }

        public static Address parse(String address) {
            int lastColonIdx;
            String scheme = "http";
            int schemeSpecIdx = address.indexOf("://");
            if (schemeSpecIdx >= 0) {
                scheme = address.substring(0, schemeSpecIdx);
                address = address.substring(schemeSpecIdx + "://".length());
            }
            if ((lastColonIdx = address.lastIndexOf(58)) == -1) {
                return new Address(address, -1);
            }
            int lastRightBracketPos = address.lastIndexOf(93);
            if (lastColonIdx > lastRightBracketPos) {
                String host = address.substring(0, lastColonIdx);
                String portSpec = address.substring(lastColonIdx + 1);
                int port = -1;
                port = WILDCARD.equals(portSpec) ? 0 : Integer.parseInt(portSpec);
                return new Address(scheme, host, port);
            }
            return new Address(scheme, address, -1);
        }

        public boolean isPortWildcard() {
            return this.port == 0;
        }

        public boolean isPortDefined() {
            return this.port != -1;
        }

        public boolean isHostWildcard() {
            return WILDCARD.equals(this.host);
        }

        public boolean isHostDefault() {
            return DEFAULT_HOST.equals(this.host);
        }

        public int hashCode() {
            int hash = this.port;
            if (this.host != null) {
                hash *= this.host.hashCode();
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Address)) {
                return false;
            }
            Address o = (Address)other;
            return Address.safeEquals(this.host, o.host) && this.port == o.port;
        }

        public boolean matches(Address other, boolean matchSchemes) {
            if (matchSchemes && !Address.safeEquals(this.scheme, other.scheme)) {
                return false;
            }
            if (!(WILDCARD.equals(this.host) || WILDCARD.equals(other.host) || Address.safeEquals(this.host, other.host))) {
                return false;
            }
            return 0 == this.port || 0 == other.port || this.port == other.port;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean includeScheme) {
            StringBuilder bld = new StringBuilder();
            if (includeScheme) {
                bld.append(this.scheme).append("://");
            }
            bld.append(this.host);
            if (this.port != -1) {
                bld.append(":");
                if (this.port == 0) {
                    bld.append(WILDCARD);
                } else {
                    bld.append(this.port);
                }
            }
            return bld.toString();
        }

        private static boolean safeEquals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

