/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.apache.util.RuntimeApacheConfiguration;

public class ApacheVirtualHostServiceDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent>,
ResourceUpgradeFacet<ApacheServerComponent> {
    private static final String COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS = "*** Could not determine the virtual host address ***";
    public static final String LOGS_DIRECTORY_NAME = "logs";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final String LEGACY_SNMP_SERVICE_INDEX_CONFIG_PROP = "snmpWwwServiceIndex";
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ApacheServerComponent serverComponent = (ApacheServerComponent)context.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.loadParser();
        tree = RuntimeApacheConfiguration.extract(tree, serverComponent.getCurrentProcessInfo(), serverComponent.getCurrentBinaryInfo(), serverComponent.getModuleNames(), false);
        this.discoverMainServer(context, discoveredResources);
        ResourceType resourceType = context.getResourceType();
        File configPath = serverComponent.getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        for (VHostSpec vhost : VHostSpec.detect(tree)) {
            String resourceKey;
            String firstAddress = vhost.hosts.get(0);
            String resourceName = resourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost.serverName, vhost.hosts);
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            HttpdAddressUtility.Address address = serverComponent.getAddressUtility().getVirtualHostSampleAddress(tree, firstAddress, vhost.serverName);
            if (address != null) {
                HttpdAddressUtility.Address serverAddress;
                String scheme = address.scheme;
                String hostToPing = address.host;
                int portToPing = address.port;
                if (address.isPortWildcard() || !address.isPortDefined()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, hostToPing, 0);
                    portToPing = serverAddress != null ? serverAddress.port : 0;
                }
                if (address.isHostDefault() || address.isHostWildcard()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, null, portToPing);
                    hostToPing = serverAddress != null ? serverAddress.host : null;
                }
                String url = hostToPing != null && portToPing != 0 && portToPing != -1 ? scheme + "://" + hostToPing + ":" + portToPing + "/" : COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS;
                PropertySimple urlProp = new PropertySimple("url", (Object)url);
                pluginConfiguration.put((Property)urlProp);
                File rtLogFile = new File(logsDir, address.host + address.port + RT_LOG_FILE_NAME_SUFFIX);
                PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
                pluginConfiguration.put((Property)rtLogProp);
                resourceName = address.toString(false, true);
            }
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
        }
        return discoveredResources;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ApacheServerComponent> inventoriedResource) {
        String resourceKey = inventoriedResource.getResourceKey();
        if ("MainServer".equals(resourceKey) || resourceKey.contains("|")) {
            return null;
        }
        String newResourceKey = null;
        ApacheServerComponent serverComponent = (ApacheServerComponent)inventoriedResource.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.loadParser();
        tree = RuntimeApacheConfiguration.extract(tree, serverComponent.getCurrentProcessInfo(), serverComponent.getCurrentBinaryInfo(), serverComponent.getModuleNames(), false);
        List<VHostSpec> vhosts = VHostSpec.detect(tree);
        String snmpServiceIndexString = inventoriedResource.getPluginConfiguration().getSimpleValue(LEGACY_SNMP_SERVICE_INDEX_CONFIG_PROP, null);
        if (snmpServiceIndexString != null) {
            Integer snmpServiceIndex = null;
            try {
                snmpServiceIndex = Integer.parseInt(snmpServiceIndexString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid format of the snmpWwwServiceIndex property value. It should be an integer but is '" + snmpServiceIndexString + "'. The upgrade will continue using the resource key matching."), (Throwable)e);
            }
            if (snmpServiceIndex != null) {
                if (snmpServiceIndex > 0) {
                    if (snmpServiceIndex == 1) {
                        newResourceKey = "MainServer";
                    } else if (vhosts.size() + 1 < snmpServiceIndex) {
                        log.warn((Object)("The snmpWwwServiceIndex property contains incorrect value (" + snmpServiceIndex + "), which is larger than the total number of active virtual hosts in the configuration files (" + (vhosts.size() + 1) + ". The upgrade will continue using the resource key matching."));
                    } else {
                        VHostSpec vhost = vhosts.get(vhosts.size() - snmpServiceIndex + 1);
                        newResourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost.serverName, vhost.hosts);
                    }
                } else {
                    log.warn((Object)("The snmpWwwServiceIndex property should be a positive integer greater than zero but is " + snmpServiceIndex + " instead. The upgrade will continue using the resource key matching."));
                }
            }
        }
        if (newResourceKey != null) {
            ResourceUpgradeReport report = new ResourceUpgradeReport();
            report.setNewResourceKey(newResourceKey);
            return report;
        }
        HashMap<String, Set<VHostSpec>> possibleMatchesPerRK = new HashMap<String, Set<VHostSpec>>();
        for (VHostSpec vhost : vhosts) {
            String[] legacyResourceKeys = ApacheVirtualHostServiceDiscoveryComponent.createLegacyResourceKeys(serverComponent, tree, vhost.serverName, vhost.hosts);
            ApacheVirtualHostServiceDiscoveryComponent.addPossibleRKMatch(legacyResourceKeys[0], vhost, possibleMatchesPerRK);
            ApacheVirtualHostServiceDiscoveryComponent.addPossibleRKMatch(legacyResourceKeys[1], vhost, possibleMatchesPerRK);
        }
        String[] mainServerRKs = ApacheVirtualHostServiceDiscoveryComponent.createLegacyMainServerResourceKey(serverComponent, tree);
        if (mainServerRKs[0] != null) {
            ApacheVirtualHostServiceDiscoveryComponent.addPossibleRKMatch(mainServerRKs[0], null, possibleMatchesPerRK);
        }
        ApacheVirtualHostServiceDiscoveryComponent.addPossibleRKMatch(mainServerRKs[1], null, possibleMatchesPerRK);
        Set matchingVhosts = (Set)possibleMatchesPerRK.get(resourceKey);
        if (matchingVhosts == null || matchingVhosts.size() != 1) {
            newResourceKey = "FailedUpgrade_" + resourceKey + "_" + UUID.randomUUID().toString();
            log.info((Object)("Failed to uniquely identify the vhost from the old-style resource key. The old resource key is '" + resourceKey + "' which can be matched with the following new-style resource keys: " + matchingVhosts + ". The match could not be established and the resource key was reset to '" + newResourceKey + "' so that this vhost resource never starts up again. This is to prevent collisions with the discoveries made " + "by this version of the plugin."));
        } else {
            VHostSpec vhost = (VHostSpec)matchingVhosts.iterator().next();
            newResourceKey = vhost == null ? "MainServer" : ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost.serverName, vhost.hosts);
        }
        ResourceUpgradeReport report = new ResourceUpgradeReport();
        report.setNewResourceKey(newResourceKey);
        return report;
    }

    private void discoverMainServer(ResourceDiscoveryContext<ApacheServerComponent> context, Set<DiscoveredResourceDetails> discoveredResources) throws Exception {
        ResourceType resourceType = context.getResourceType();
        Configuration mainServerPluginConfig = context.getDefaultPluginConfiguration();
        File configPath = ((ApacheServerComponent)context.getParentResourceComponent()).getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        String mainServerUrl = context.getParentResourceContext().getPluginConfiguration().getSimple("url").getStringValue();
        if (mainServerUrl != null && !"null".equals(mainServerUrl)) {
            PropertySimple mainServerUrlProp = new PropertySimple("url", (Object)mainServerUrl);
            mainServerPluginConfig.put((Property)mainServerUrlProp);
            URI mainServerUri = new URI(mainServerUrl);
            String host = mainServerUri.getHost();
            int port = mainServerUri.getPort();
            if (port == -1) {
                port = 80;
            }
            File rtLogFile = new File(logsDir, host + port + RT_LOG_FILE_NAME_SUFFIX);
            PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
            mainServerPluginConfig.put((Property)rtLogProp);
        }
        String key = "MainServer";
        DiscoveredResourceDetails mainServer = new DiscoveredResourceDetails(resourceType, key, "Main", null, null, mainServerPluginConfig, null);
        discoveredResources.add(mainServer);
    }

    public static String createResourceKey(String serverName, List<String> hosts) {
        StringBuilder keyBuilder = new StringBuilder();
        if (serverName != null) {
            keyBuilder.append(serverName);
        }
        keyBuilder.append("|");
        keyBuilder.append(hosts.get(0));
        for (int i = 1; i < hosts.size(); ++i) {
            keyBuilder.append(" ").append(hosts.get(i));
        }
        return keyBuilder.toString();
    }

    private static String[] createLegacyResourceKeys(ApacheServerComponent serverComponent, ApacheDirectiveTree runtimeConfig, String serverName, List<String> hosts) {
        String[] ret = new String[2];
        HttpdAddressUtility.Address internalAddress = serverComponent.getAddressUtility().getHttpdInternalVirtualHostAddressRepresentation(runtimeConfig, hosts.get(0), serverName);
        ret[0] = internalAddress.host + ":" + internalAddress.port;
        String host = hosts.get(0);
        HttpdAddressUtility.Address hostAddr = HttpdAddressUtility.Address.parse(host);
        if (serverName != null) {
            HttpdAddressUtility.Address serverAddr = HttpdAddressUtility.Address.parse(serverName);
            hostAddr.host = serverAddr.host;
        }
        try {
            InetAddress hostName = InetAddress.getByName(hostAddr.host);
            hostAddr.host = hostName.getHostName();
        }
        catch (UnknownHostException e) {
            log.debug((Object)("Host " + hostAddr.host + " is not resolvable."), (Throwable)e);
        }
        ret[1] = hostAddr.host + ":" + hostAddr.port;
        return ret;
    }

    private static String[] createLegacyMainServerResourceKey(ApacheServerComponent serverComponent, ApacheDirectiveTree runtimeConfig) {
        String[] ret = new String[2];
        ret[0] = serverComponent.getServerUrl();
        if (serverComponent.getServerUrl() != null) {
            try {
                URI mainServerUri = new URI(serverComponent.getServerUrl());
                String host = mainServerUri.getHost();
                int port = mainServerUri.getPort();
                if (port == -1) {
                    port = 80;
                }
                ret[0] = host + ":" + port;
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        HttpdAddressUtility.Address addr = serverComponent.getAddressUtility().getHttpdInternalMainServerAddressRepresentation(runtimeConfig);
        ret[1] = addr.host + ":" + addr.port;
        return ret;
    }

    private static void addPossibleRKMatch(String resourceKey, VHostSpec vhost, Map<String, Set<VHostSpec>> possibleMatches) {
        Set<VHostSpec> matches = possibleMatches.get(resourceKey);
        if (matches == null) {
            matches = new HashSet<VHostSpec>();
            possibleMatches.put(resourceKey, matches);
        }
        matches.add(vhost);
    }

    private static class VHostSpec {
        public String serverName;
        public List<String> hosts;

        public static List<VHostSpec> detect(ApacheDirectiveTree config) {
            List<ApacheDirective> virtualHosts = config.search("/<VirtualHost");
            ArrayList<VHostSpec> ret = new ArrayList<VHostSpec>(virtualHosts.size());
            for (ApacheDirective dir : virtualHosts) {
                ret.add(new VHostSpec(dir));
            }
            return ret;
        }

        public VHostSpec(ApacheDirective vhostDirective) {
            this.hosts = vhostDirective.getValues();
            List<ApacheDirective> serverNames = vhostDirective.getChildByName("ServerName");
            this.serverName = null;
            if (serverNames.size() > 0) {
                this.serverName = serverNames.get(serverNames.size() - 1).getValuesAsString();
            }
        }

        public String toString() {
            return ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(this.serverName, this.hosts);
        }
    }
}

