/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.util.OSGiVersionComparator;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;

public class RuntimeApacheConfiguration {
    private static final Log LOG = LogFactory.getLog(RuntimeApacheConfiguration.class);
    private static final Set<String> LOGGED_UNKNOWN_MODULES = Collections.synchronizedSet(new HashSet());

    private RuntimeApacheConfiguration() {
    }

    public static ApacheDirectiveTree extract(ApacheDirectiveTree tree, ProcessInfo httpdProcessInfo, ApacheBinaryInfo httpdBinaryInfo, Map<String, String> moduleNames, boolean suppressUnknownModuleWarnings) {
        ApacheDirectiveTree ret = tree.clone();
        RuntimeApacheConfiguration.transform(new TransformingWalker(), ret.getRootNode(), new TransformState(httpdProcessInfo, httpdBinaryInfo, moduleNames, suppressUnknownModuleWarnings));
        return ret;
    }

    public static void walkRuntimeConfig(final NodeVisitor<ApacheDirective> visitor, ApacheDirectiveTree tree, ProcessInfo httpdProcessInfo, ApacheBinaryInfo httpdBinaryInfo, Map<String, String> moduleNames, boolean suppressUnknownModuleWarnings) {
        TreeWalker<ApacheDirective> walker = new TreeWalker<ApacheDirective>(){

            @Override
            public void visitConditionalNode(ApacheDirective node, boolean isSatisfied) {
                visitor.visitConditionalNode(node, isSatisfied);
            }

            @Override
            public void visitOrdinaryNode(ApacheDirective node) {
                visitor.visitOrdinaryNode(node);
            }

            @Override
            public void onBeforeChildrenScan(ApacheDirective node) {
            }

            @Override
            public void onAfterChildrenScan(ApacheDirective node) {
            }

            @Override
            public Collection<ApacheDirective> getChildren(ApacheDirective node) {
                return node.getChildDirectives();
            }

            @Override
            public String getValue(ApacheDirective node) {
                return node.getValuesAsString();
            }

            @Override
            public List<String> getValues(ApacheDirective node) {
                return node.getValues();
            }

            @Override
            public String getName(ApacheDirective node) {
                return node.getName();
            }
        };
        RuntimeApacheConfiguration.transform(walker, tree.getRootNode(), new TransformState(httpdProcessInfo, httpdBinaryInfo, moduleNames, suppressUnknownModuleWarnings));
    }

    public static void walkRuntimeConfig(final NodeVisitor<AugeasNode> visitor, AugeasTree tree, ProcessInfo httpdProcessInfo, ApacheBinaryInfo httpdBinaryInfo, Map<String, String> moduleNames, boolean suppressUnknownModuleWarnings) {
        TreeWalker<AugeasNode> walker = new TreeWalker<AugeasNode>(){

            @Override
            public void visitConditionalNode(AugeasNode node, boolean isSatisfied) {
                visitor.visitConditionalNode(node, isSatisfied);
            }

            @Override
            public void visitOrdinaryNode(AugeasNode node) {
                visitor.visitOrdinaryNode(node);
            }

            @Override
            public void onBeforeChildrenScan(AugeasNode node) {
            }

            @Override
            public void onAfterChildrenScan(AugeasNode node) {
            }

            @Override
            public Collection<AugeasNode> getChildren(AugeasNode node) {
                return node.getChildNodes();
            }

            @Override
            public String getValue(AugeasNode node) {
                StringBuilder bld = new StringBuilder();
                for (String val : this.getValues(node)) {
                    bld.append(val);
                }
                return bld.toString();
            }

            @Override
            public List<String> getValues(AugeasNode node) {
                ArrayList<String> ret = new ArrayList<String>();
                List params = node.getChildByLabel("param");
                for (AugeasNode n : params) {
                    ret.add(n.getValue());
                }
                return ret;
            }

            @Override
            public String getName(AugeasNode node) {
                return node.getLabel();
            }
        };
        RuntimeApacheConfiguration.transform(walker, tree.getRootNode(), new TransformState(httpdProcessInfo, httpdBinaryInfo, moduleNames, suppressUnknownModuleWarnings));
    }

    private static <T> void transform(TreeWalker<T> walker, T parentNode, TransformState state) {
        if (walker.getChildren(parentNode).isEmpty()) {
            return;
        }
        walker.onBeforeChildrenScan(parentNode);
        block5: for (T node : walker.getChildren(parentNode)) {
            boolean result;
            boolean recurseFurther = true;
            if (walker.getName(node).equalsIgnoreCase("LoadModule")) {
                state.loadedModules.add(walker.getValues(node).get(0));
                walker.visitOrdinaryNode(node);
            } else if (walker.getName(node).equalsIgnoreCase("<IfModule")) {
                String moduleFile = walker.getValue(node);
                boolean negate = false;
                if (moduleFile.startsWith("!")) {
                    negate = true;
                    moduleFile = moduleFile.substring(1);
                }
                result = false;
                switch (RuntimeApacheConfiguration.isModuleLoaded(moduleFile, state.loadedModules, state.moduleNames, state.moduleFiles)) {
                    case LOADED: {
                        result = true;
                        break;
                    }
                    case NOT_LOADED: {
                        result = false;
                        break;
                    }
                    case UNKNOWN: {
                        if (state.suppressUnknownModuleWarnings && LOGGED_UNKNOWN_MODULES.contains(moduleFile)) {
                            LOG.debug((Object)("Encountered unknown module name in an IfModule directive: " + moduleFile));
                        } else {
                            LOG.warn((Object)("Encountered unknown module name in an IfModule directive: " + moduleFile + ". If you are using Apache 2.1 or later, you can try changing the module identifier from the source file to " + "the actual module name as used in the LoadModule directive to get rid of this warning."));
                        }
                        LOGGED_UNKNOWN_MODULES.add(moduleFile);
                        continue block5;
                    }
                }
                recurseFurther = result != negate;
                walker.visitConditionalNode(node, recurseFurther);
            } else if (walker.getName(node).equalsIgnoreCase("<IfDefine")) {
                String define = walker.getValue(node);
                boolean negate = false;
                if (define.startsWith("!")) {
                    negate = true;
                    define = define.substring(1);
                }
                recurseFurther = (result = state.defines.contains(define)) != negate;
                walker.visitConditionalNode(node, recurseFurther);
            } else if (walker.getName(node).equalsIgnoreCase("<IfVersion")) {
                if (RuntimeApacheConfiguration.isModuleLoaded("mod_version.c", state.loadedModules, state.moduleNames, state.moduleFiles) != ModuleLoadedState.LOADED) {
                    LOG.debug((Object)"mod_version not loaded and IfVersion directive encountered. Skipping it.");
                    continue;
                }
                List<String> values = walker.getValues(node);
                String operator = null;
                String version = null;
                boolean negate = false;
                boolean regex = false;
                if (values.size() == 0) {
                    LOG.warn((Object)"Invalid IfVersion directive.");
                    continue;
                }
                if (values.size() == 1) {
                    operator = "=";
                    version = values.get(0);
                } else if (values.size() == 2) {
                    operator = values.get(0);
                    version = values.get(1);
                } else {
                    LOG.warn((Object)("Too many arguments to a IfVersion directive: " + values));
                    continue;
                }
                if (operator == null || version == null) {
                    LOG.warn((Object)("Invalid IfVersion with parameters: " + values));
                    continue;
                }
                if (operator.charAt(0) == '!') {
                    negate = true;
                    operator = operator.substring(1);
                }
                if ("==".equals(operator)) {
                    operator = "=";
                }
                if (version.charAt(0) == '/') {
                    if ("=".equals(operator) || "~".equals(operator)) {
                        regex = true;
                        version = version.substring(1, version.length() - 1);
                    } else {
                        LOG.warn((Object)("Unsupported operator " + operator + " with regex version comparison in IfVersion directive."));
                        continue;
                    }
                }
                OSGiVersionComparator comp = new OSGiVersionComparator();
                boolean result2 = false;
                if ("=".equals(operator)) {
                    result2 = regex ? Pattern.matches(version, state.httpdVersion) : comp.compare(version, state.httpdVersion) == 0;
                } else if ("~".equals(operator)) {
                    result2 = Pattern.matches(version, state.httpdVersion);
                } else if (">".equals(operator)) {
                    result2 = comp.compare(state.httpdVersion, version) > 0;
                } else if (">=".equals(operator)) {
                    result2 = comp.compare(state.httpdVersion, version) >= 0;
                } else if ("<".equals(operator)) {
                    result2 = comp.compare(state.httpdVersion, version) < 0;
                } else if ("<=".equals(operator)) {
                    result2 = comp.compare(state.httpdVersion, version) <= 0;
                } else {
                    LOG.warn((Object)("Unknown operator " + operator + " in an IfVersion directive."));
                    continue;
                }
                recurseFurther = result2 != negate;
                walker.visitConditionalNode(node, recurseFurther);
            } else {
                walker.visitOrdinaryNode(node);
            }
            if (!recurseFurther) continue;
            RuntimeApacheConfiguration.transform(walker, node, state);
        }
        walker.onAfterChildrenScan(parentNode);
    }

    private static ModuleLoadedState isModuleLoaded(String moduleIdentifier, Set<String> currentlyLoadedModules, Map<String, String> moduleNames, Map<String, String> moduleFiles) {
        String moduleName = moduleNames.get(moduleIdentifier);
        if (moduleName == null && (moduleIdentifier = moduleFiles.get(moduleName = moduleIdentifier)) == null) {
            if (moduleName.endsWith(".c")) {
                return ModuleLoadedState.UNKNOWN;
            }
            return currentlyLoadedModules.contains(moduleName) ? ModuleLoadedState.LOADED : ModuleLoadedState.NOT_LOADED;
        }
        boolean result = currentlyLoadedModules.contains(moduleIdentifier) || currentlyLoadedModules.contains(moduleName);
        return result ? ModuleLoadedState.LOADED : ModuleLoadedState.NOT_LOADED;
    }

    private static class TransformState {
        public Set<String> loadedModules;
        public Set<String> defines;
        public Map<String, String> moduleNames;
        public Map<String, String> moduleFiles;
        public String httpdVersion;
        public boolean suppressUnknownModuleWarnings;

        public TransformState(ProcessInfo httpdProcessInfo, ApacheBinaryInfo httpdBinaryInfo, Map<String, String> moduleNames, boolean suppressUnknownModuleWarnings) {
            this.defines = new HashSet<String>(httpdBinaryInfo.getCompiledInDefines());
            if (httpdProcessInfo != null) {
                String[] args = httpdProcessInfo.getCommandLine();
                for (int i = 1; i < args.length; ++i) {
                    String define = null;
                    if (args[i] != null && args[i].startsWith("-D")) {
                        define = args[i].substring(2).trim();
                    }
                    if (define != null && define.isEmpty()) {
                        if (i < args.length - 1) {
                            define = args[i + 1].trim();
                            if (define.startsWith("-")) {
                                define = null;
                            } else {
                                ++i;
                            }
                        } else {
                            define = null;
                        }
                    }
                    if (define == null) continue;
                    this.defines.add(define);
                }
            }
            this.loadedModules = new HashSet<String>();
            this.loadedModules.addAll(httpdBinaryInfo.getCompiledInModules());
            this.moduleNames = moduleNames;
            this.moduleFiles = new HashMap<String, String>(moduleNames.size());
            for (Map.Entry<String, String> e : moduleNames.entrySet()) {
                this.moduleFiles.put(e.getValue(), e.getKey());
            }
            this.httpdVersion = httpdBinaryInfo.getVersion();
            this.suppressUnknownModuleWarnings = suppressUnknownModuleWarnings;
        }
    }

    private static class TransformingWalker
    implements TreeWalker<ApacheDirective> {
        private Deque<NodesToModify> currentNodeStack = new ArrayDeque<NodesToModify>();

        private TransformingWalker() {
        }

        @Override
        public void visitConditionalNode(ApacheDirective node, boolean isSatisfied) {
            NodesToModify nodes = this.currentNodeStack.peek();
            if (isSatisfied) {
                nodes.nodesToPromote.add(node);
            } else {
                nodes.nodesToRemove.add(node);
            }
        }

        @Override
        public void visitOrdinaryNode(ApacheDirective node) {
        }

        @Override
        public void onBeforeChildrenScan(ApacheDirective node) {
            this.currentNodeStack.push(new NodesToModify());
        }

        @Override
        public void onAfterChildrenScan(ApacheDirective parentNode) {
            NodesToModify nodes = this.currentNodeStack.pop();
            for (ApacheDirective node : nodes.nodesToRemove) {
                parentNode.getChildDirectives().remove(node);
            }
            for (ApacheDirective node : nodes.nodesToPromote) {
                int nodeIdx = parentNode.getChildDirectives().indexOf(node);
                List<ApacheDirective> childNodes = node.getChildDirectives();
                for (int i = childNodes.size() - 1; i >= 0; --i) {
                    ApacheDirective childNode = childNodes.get(i);
                    parentNode.getChildDirectives().add(nodeIdx, childNode);
                    childNode.setParentNode(parentNode);
                }
                parentNode.getChildDirectives().remove(nodeIdx + childNodes.size());
            }
        }

        @Override
        public Collection<ApacheDirective> getChildren(ApacheDirective node) {
            return node.getChildDirectives();
        }

        @Override
        public String getValue(ApacheDirective node) {
            return node.getValuesAsString();
        }

        @Override
        public List<String> getValues(ApacheDirective node) {
            return node.getValues();
        }

        @Override
        public String getName(ApacheDirective node) {
            return node.getName();
        }

        private static class NodesToModify {
            ArrayList<ApacheDirective> nodesToRemove = new ArrayList();
            ArrayList<ApacheDirective> nodesToPromote = new ArrayList();

            private NodesToModify() {
            }
        }
    }

    private static interface TreeWalker<T>
    extends NodeVisitor<T> {
        public void onBeforeChildrenScan(T var1);

        public void onAfterChildrenScan(T var1);

        public Collection<T> getChildren(T var1);

        public String getValue(T var1);

        public List<String> getValues(T var1);

        public String getName(T var1);
    }

    public static interface NodeVisitor<T> {
        public void visitConditionalNode(T var1, boolean var2);

        public void visitOrdinaryNode(T var1);
    }

    private static enum ModuleLoadedState {
        LOADED,
        NOT_LOADED,
        UNKNOWN;

    }
}

